import { Component } from "projen";
import { Language } from "../../languages";
import { SmithyModelOptions } from "../../types";
import { TypeSafeApiModelProject } from "../type-safe-api-model-project";
/**
 * Options for a smithy build project
 */
export interface SmithyDefinitionOptions {
    /**
     * Smithy engine options
     */
    readonly smithyOptions: SmithyModelOptions;
    /**
     * The languages users have specified for handler projects (if any)
     */
    readonly handlerLanguages?: Language[];
}
/**
 * Creates a project which transforms a Smithy model to OpenAPI
 */
export declare class SmithyDefinition extends Component {
    /**
     * Path to the generated OpenAPI specification, relative to the project outdir
     */
    readonly openApiSpecificationPath: string;
    /**
     * Path to the json Smithy model, relative to the project outdir
     */
    readonly smithyJsonModelPath: string;
    /**
     * Name of the gradle project
     */
    readonly gradleProjectName: string;
    /**
     * Reference to the build.gradle file component
     * @private
     */
    private readonly smithyBuildGradleFile;
    /**
     * Reference to the smithy-build.json file component
     * @private
     */
    private readonly smithyBuild;
    constructor(project: TypeSafeApiModelProject, options: SmithyDefinitionOptions);
    /**
     * Add maven-style or local file dependencies to the smithy model project
     * @param deps dependencies to add, eg "software.amazon.smithy:smithy-validation-model:1.27.2" or "file://../some/path/build/lib/my-shapes.jar
     */
    addDeps(...deps: string[]): void;
    /**
     * Add dependencies on other smithy models, such that their shapes can be imported in this project
     * @param deps smithy definitions to depend on
     */
    addSmithyDeps(...deps: SmithyDefinition[]): void;
    /**
     * Add additional paths to model source files or directories.
     * Paths should be relative to the project outdir. Any absolute paths will be
     * resolved as relative paths.
     */
    addSources(...sources: string[]): void;
    /**
     * Convert any given absolute paths to relative paths to the project outdir
     * @private
     */
    private asRelativePathsToProject;
}
