"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Architecture = exports.ModelLanguage = void 0;
/**
 * The model definition language
 */
var ModelLanguage;
(function (ModelLanguage) {
    /**
     * Smithy
     * @see https://smithy.io/2.0/
     */
    ModelLanguage["SMITHY"] = "SMITHY";
    /**
     * OpenAPI
     * @see https://www.openapis.org/
     */
    ModelLanguage["OPENAPI"] = "OPENAPI";
})(ModelLanguage || (exports.ModelLanguage = ModelLanguage = {}));
/**
 * Represents an instruction set architecture
 */
var Architecture;
(function (Architecture) {
    /**
     * 64-bit x86 architecture
     */
    Architecture["X86_64"] = "X86_64";
    /**
     * 64-bit ARM architecture
     */
    Architecture["ARM_64"] = "ARM_64";
})(Architecture || (exports.Architecture = Architecture = {}));
//# sourceMappingURL=data:application/json;base64,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