/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.acearth.scanbit;

import com.ctreber.acearth.projection.Projection;
import com.ctreber.acearth.scanbit.BitGeneratorMap;
import com.ctreber.acearth.scanbit.ScanBuf;
import com.ctreber.acearth.util.EdgeCrossing;
import com.ctreber.acearth.util.Point2D;
import com.ctreber.acearth.util.Point3D;
import java.util.Comparator;

public class BitGeneratorMapOrtho
extends BitGeneratorMap {
    public BitGeneratorMapOrtho(Projection projection) {
        super(projection);
    }

    @Override
    protected Comparator getEdgeXingComparator() {
        return new EdgeCrossingComparator();
    }

    @Override
    protected ScanBuf scanOutline() {
        ScanBuf scanBuf = new ScanBuf(this.fImageHeight, this.fImageWidth);
        this.addArcToScanbuf(scanBuf, 1.0, 0.0, 0.0, 1.0, 0.0, Math.PI * 2);
        return scanBuf;
    }

    private void addArcToScanbuf(ScanBuf scanBuf, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9 = 1.0 / this.fProjection.getScale() * 10.0;
        if (d9 > 0.05) {
            d9 = 0.05;
        }
        int n = (int)Math.ceil(d3 / d9);
        int n2 = (int)Math.floor(d6 / d9);
        double d10 = this.fProjection.finalizeX(d);
        double d11 = this.fProjection.finalizeY(d2);
        if (n <= n2) {
            double d12 = Math.cos(d9);
            double d13 = Math.sin(d9);
            double d14 = (double)n * d9;
            double d15 = Math.cos(d14);
            double d16 = Math.sin(d14);
            for (int i = n; i <= n2; ++i) {
                d8 = this.fProjection.finalizeX(d15);
                d7 = this.fProjection.finalizeY(d16);
                scanBuf.addLine(d10, d11, d8, d7);
                double d17 = d12 * d15 - d13 * d16;
                d16 = d13 * d15 + d12 * d16;
                d15 = d17;
                d10 = d8;
                d11 = d7;
            }
        }
        d8 = this.fProjection.finalizeX(d4);
        d7 = this.fProjection.finalizeY(d5);
        scanBuf.addLine(d10, d11, d8, d7);
    }

    @Override
    protected void scanPolygon(ScanBuf scanBuf, Point3D[] point3DArray, Point2D[] point2DArray, int n) {
        Point3D point3D = point3DArray[n];
        int n2 = n - 1 >= 0 ? n - 1 : point2DArray.length - 1;
        Point3D point3D2 = point3DArray[n2];
        if (point3D2.getZ() <= 0.0) {
            if (point3D.getZ() <= 0.0) {
                return;
            }
            Point3D point3D3 = this.findEdgeCrossing(point3D2, point3D);
            this.addEdgeXing(new EdgeCrossing(0, n, point3D3.getX(), point3D3.getY(), Math.atan2(point3D3.getY(), point3D3.getX())));
            point3D2 = point3D3;
        } else if (point3D.getZ() <= 0.0) {
            Point3D point3D4 = this.findEdgeCrossing(point3D2, point3D);
            this.addEdgeXing(new EdgeCrossing(1, n, point3D4.getX(), point3D4.getY(), Math.atan2(point3D4.getY(), point3D4.getX())));
            point3D = point3D4;
        }
        scanBuf.addLine(this.fProjection.finalizeX(point3D2.getX()), this.fProjection.finalizeY(point3D2.getY()), this.fProjection.finalizeX(point3D.getX()), this.fProjection.finalizeY(point3D.getY()));
    }

    private Point3D findEdgeCrossing(Point3D point3D, Point3D point3D2) {
        double d = point3D2.getZ() / (point3D2.getZ() - point3D.getZ());
        double d2 = point3D2.getX() - d * (point3D2.getX() - point3D.getX());
        double d3 = point3D2.getY() - d * (point3D2.getY() - point3D.getY());
        d = Math.sqrt(d2 * d2 + d3 * d3);
        return new Point3D(d2 / d, d3 / d, 0.0);
    }

    @Override
    protected void handleCrossings(ScanBuf scanBuf, EdgeCrossing[] edgeCrossingArray) {
        EdgeCrossing edgeCrossing;
        EdgeCrossing edgeCrossing2;
        int n;
        if (edgeCrossingArray[0].getType() == 1) {
            n = 0;
        } else {
            edgeCrossing2 = edgeCrossingArray[edgeCrossingArray.length - 1];
            edgeCrossing = edgeCrossingArray[0];
            this.addArcToScanbuf(scanBuf, edgeCrossing2.getX(), edgeCrossing2.getY(), edgeCrossing2.getAngle(), edgeCrossing.getX(), edgeCrossing.getY(), edgeCrossing.getAngle() + Math.PI * 2);
            n = 1;
        }
        for (int i = n; i < edgeCrossingArray.length - 1; i += 2) {
            edgeCrossing2 = edgeCrossingArray[i];
            edgeCrossing = edgeCrossingArray[i + 1];
            this.addArcToScanbuf(scanBuf, edgeCrossing2.getX(), edgeCrossing2.getY(), edgeCrossing2.getAngle(), edgeCrossing.getX(), edgeCrossing.getY(), edgeCrossing.getAngle());
        }
    }

    private static class EdgeCrossingComparator
    implements Comparator {
        private EdgeCrossingComparator() {
        }

        public int compare(Object object, Object object2) {
            EdgeCrossing edgeCrossing = (EdgeCrossing)object;
            EdgeCrossing edgeCrossing2 = (EdgeCrossing)object2;
            return edgeCrossing.getAngle() < edgeCrossing2.getAngle() ? -1 : (edgeCrossing.getAngle() > edgeCrossing2.getAngle() ? 1 : 0);
        }
    }
}

