/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.aclib.gui;

import com.ctreber.aclib.gui.MonitoredObject;

public class MOInteger
extends MonitoredObject {
    private int fInteger;
    private boolean fCheckRange = false;
    private int fMin;
    private int fMax;

    public MOInteger() {
    }

    public MOInteger(int n) {
        this.fInteger = n;
    }

    public MOInteger(int n, int n2, int n3) {
        this.fMin = n2;
        this.fMax = n3;
        this.fCheckRange = true;
        this.set(n);
    }

    public void set(int n) {
        if (!this.checkRange(n)) {
            throw new IllegalArgumentException("Argument '" + n + "' out of range [" + MOInteger.niceFormat(this.fMin) + "; " + MOInteger.niceFormat(this.fMax) + "]");
        }
        this.fInteger = n;
        this.fireValueChanged();
    }

    private static String niceFormat(int n) {
        if (n == Integer.MAX_VALUE) {
            return "Infinity";
        }
        if (n == Integer.MIN_VALUE) {
            return "-Infinity";
        }
        return Integer.toString(n);
    }

    public int get() {
        return this.fInteger;
    }

    private boolean checkRange(int n) {
        return !this.fCheckRange || this.fMin <= n && n <= this.fMax;
    }

    @Override
    public boolean checkRange() {
        return this.checkRange(this.fInteger);
    }
}

