/*
 * Decompiled with CFR 0.152.
 */
package jcckit.graphic;

import java.awt.Color;
import jcckit.graphic.Anchor;
import jcckit.graphic.FontStyle;
import jcckit.graphic.ShapeAttributes;
import jcckit.graphic.TextAttributes;
import jcckit.util.ConfigParameters;

public class BasicGraphicAttributes
extends ShapeAttributes
implements TextAttributes {
    public static final String TEXT_COLOR_KEY = "textColor";
    public static final String FONT_NAME_KEY = "fontName";
    public static final String FONT_STYLE_KEY = "fontStyle";
    public static final String FONT_SIZE_KEY = "fontSize";
    public static final String HORIZONTAL_ANCHOR_KEY = "horizontalAnchor";
    public static final String VERTICAL_ANCHOR_KEY = "verticalAnchor";
    public static final String ORIENTATION_ANGLE_KEY = "orientationAngle";
    private final Color _textColor;
    private final String _fontName;
    private final FontStyle _fontStyle;
    private final double _fontSize;
    private final double _orientationAngle;
    private final Anchor _horizontalAnchor;
    private final Anchor _verticalAnchor;

    public BasicGraphicAttributes(ConfigParameters configParameters) {
        super(configParameters);
        this._textColor = configParameters.getColor(TEXT_COLOR_KEY, null);
        this._fontName = configParameters.get(FONT_NAME_KEY, null);
        this._fontStyle = FontStyle.getFontStyle(configParameters, FONT_STYLE_KEY, FontStyle.NORMAL);
        this._fontSize = configParameters.getDouble(FONT_SIZE_KEY, 0.0);
        this._orientationAngle = configParameters.getDouble(ORIENTATION_ANGLE_KEY, 0.0);
        this._horizontalAnchor = Anchor.getHorizontalAnchor(configParameters, HORIZONTAL_ANCHOR_KEY, Anchor.LEFT_BOTTOM);
        this._verticalAnchor = Anchor.getVerticalAnchor(configParameters, VERTICAL_ANCHOR_KEY, Anchor.CENTER);
    }

    public BasicGraphicAttributes(Color color, Color color2, double d, double[] dArray, Color color3, String string, FontStyle fontStyle, double d2, double d3, Anchor anchor, Anchor anchor2) {
        super(color, color2, d, dArray);
        this._textColor = color3;
        this._fontName = string;
        this._fontStyle = fontStyle;
        this._fontSize = d2;
        this._orientationAngle = d3;
        this._horizontalAnchor = anchor;
        this._verticalAnchor = anchor2;
    }

    @Override
    public Color getTextColor() {
        return this._textColor;
    }

    @Override
    public String getFontName() {
        return this._fontName;
    }

    @Override
    public FontStyle getFontStyle() {
        return this._fontStyle;
    }

    @Override
    public double getFontSize() {
        return this._fontSize;
    }

    @Override
    public double getOrientationAngle() {
        return this._orientationAngle;
    }

    @Override
    public Anchor getHorizontalAnchor() {
        return this._horizontalAnchor;
    }

    @Override
    public Anchor getVerticalAnchor() {
        return this._verticalAnchor;
    }
}

