/*
 * Decompiled with CFR 0.152.
 */
package jcckit.graphic;

import jcckit.graphic.BasicGraphicalElement;
import jcckit.graphic.ClippingShape;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.Rectangle;

public class ClippingRectangle
implements ClippingShape {
    private final double _minX;
    private final double _minY;
    private final double _maxX;
    private final double _maxY;

    public ClippingRectangle(double d, double d2, double d3, double d4) {
        this._minX = Math.min(d, d3);
        this._minY = Math.min(d2, d4);
        this._maxX = Math.max(d, d3);
        this._maxY = Math.max(d2, d4);
    }

    @Override
    public boolean isInside(GraphPoint graphPoint) {
        double d = graphPoint.getX();
        double d2 = graphPoint.getY();
        return this._minX <= d && d <= this._maxX && this._minY <= d2 && d2 <= this._maxY;
    }

    public double getMinX() {
        return this._minX;
    }

    public double getMaxX() {
        return this._maxX;
    }

    public double getMinY() {
        return this._minY;
    }

    public double getMaxY() {
        return this._maxY;
    }

    @Override
    public ClippingRectangle getBoundingBox() {
        return this;
    }

    @Override
    public BasicGraphicalElement getGraphicalElement() {
        return new Rectangle(new GraphPoint(0.5 * (this._minX + this._maxX), 0.5 * (this._minY + this._maxY)), this._maxX - this._minX, this._maxY - this._minY, null);
    }
}

