/*
 * Decompiled with CFR 0.152.
 */
package jcckit.graphic;

import java.util.Vector;
import jcckit.graphic.ClippingShape;
import jcckit.graphic.GraphicalCompositeRenderer;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.Renderer;

public class GraphicalComposite
implements GraphicalElement {
    private final Vector _elements = new Vector();
    private final ClippingShape _clippingShape;

    public GraphicalComposite(ClippingShape clippingShape) {
        this._clippingShape = clippingShape;
    }

    public ClippingShape getClippingShape() {
        return this._clippingShape;
    }

    public void addElement(GraphicalElement graphicalElement) {
        if (graphicalElement == null) {
            this.throwNullPointerException();
        } else {
            this._elements.addElement(graphicalElement);
        }
    }

    public void removeAllElements() {
        this._elements.removeAllElements();
    }

    public void replaceElementAt(int n, GraphicalElement graphicalElement) {
        if (graphicalElement == null) {
            this.throwNullPointerException();
        } else {
            this._elements.setElementAt(graphicalElement, n);
        }
    }

    private void throwNullPointerException() {
        throw new NullPointerException("A null as an GraphicalElement is not allowed");
    }

    @Override
    public void renderWith(Renderer renderer) {
        GraphicalCompositeRenderer graphicalCompositeRenderer;
        if (renderer instanceof GraphicalCompositeRenderer) {
            graphicalCompositeRenderer = (GraphicalCompositeRenderer)renderer;
            graphicalCompositeRenderer.startRendering(this);
            int n = this._elements.size();
            for (int i = 0; i < n; ++i) {
                ((GraphicalElement)this._elements.elementAt(i)).renderWith(graphicalCompositeRenderer);
            }
        } else {
            throw new IllegalArgumentException(renderer + " does not implements GraphicalCompositeRenderer.");
        }
        graphicalCompositeRenderer.finishRendering(this);
    }
}

