/*
 * Decompiled with CFR 0.152.
 */
package jcckit.graphic;

import java.util.Vector;
import jcckit.graphic.BasicGraphicalElement;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.PolygonRenderer;
import jcckit.graphic.Renderer;

public class Polygon
extends BasicGraphicalElement {
    private final Vector _points = new Vector();
    private final boolean _closed;

    public Polygon(GraphicAttributes graphicAttributes, boolean bl) {
        super(graphicAttributes);
        this._closed = bl;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    public int getNumberOfPoints() {
        return this._points.size();
    }

    public GraphPoint getPoint(int n) {
        return (GraphPoint)this._points.elementAt(n);
    }

    public void addPoint(GraphPoint graphPoint) {
        this._points.addElement(graphPoint);
    }

    public void removeAllPoints() {
        this._points.removeAllElements();
    }

    public void replacePointAt(int n, GraphPoint graphPoint) {
        this._points.setElementAt(graphPoint, n);
    }

    @Override
    public void renderWith(Renderer renderer) {
        if (!(renderer instanceof PolygonRenderer)) {
            throw new IllegalArgumentException(renderer + " does not implements PolygonRenderer.");
        }
        ((PolygonRenderer)renderer).render(this);
    }
}

