/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalElement;
import jcckit.plot.AttributesHint;
import jcckit.plot.Hint;
import jcckit.plot.Symbol;
import jcckit.plot.SymbolFactory;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;

public abstract class AbstractSymbolFactory
implements SymbolFactory {
    protected final double _size;
    protected final GraphicAttributes _attributes;

    public AbstractSymbolFactory(ConfigParameters configParameters) {
        this._size = configParameters.getDouble("size", 0.01);
        this._attributes = (GraphicAttributes)Factory.createOrGet(configParameters.getNode("attributes"), null);
    }

    @Override
    public Symbol createSymbol(GraphPoint graphPoint, Hint hint, Hint hint2) {
        GraphicAttributes graphicAttributes = this._attributes;
        Hint hint3 = hint;
        if (hint instanceof AttributesHint) {
            graphicAttributes = ((AttributesHint)hint).getAttributes();
            hint3 = ((AttributesHint)hint).getNextHint();
        }
        return this.createSymbol(graphPoint, graphicAttributes, hint3, hint2);
    }

    protected Symbol createSymbol(GraphPoint graphPoint, GraphicAttributes graphicAttributes, Hint hint, Hint hint2) {
        return new Symbol(this.createPlainSymbol(graphPoint, this._size, graphicAttributes), hint, hint2);
    }

    @Override
    public GraphicalElement createLegendSymbol(GraphPoint graphPoint, double d) {
        return this.createPlainSymbol(graphPoint, this._size, this._attributes);
    }

    protected abstract GraphicalElement createPlainSymbol(GraphPoint var1, double var2, GraphicAttributes var4);
}

