/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.Rectangle;
import jcckit.plot.AbstractSymbolFactory;
import jcckit.plot.Hint;
import jcckit.plot.PositionHint;
import jcckit.plot.Symbol;
import jcckit.util.ConfigParameters;

public class BarFactory
extends AbstractSymbolFactory {
    public static final String STACKED_KEY = "stacked";
    public static final String HORIZONTAL_BARS_KEY = "horizontalBars";
    private final boolean _stacked;
    private final boolean _horizontalBars;

    public BarFactory(ConfigParameters configParameters) {
        super(configParameters);
        this._horizontalBars = configParameters.getBoolean(HORIZONTAL_BARS_KEY, false);
        this._stacked = configParameters.getBoolean(STACKED_KEY, false);
    }

    @Override
    protected Symbol createSymbol(GraphPoint graphPoint, GraphicAttributes graphicAttributes, Hint hint, Hint hint2) {
        GraphPoint graphPoint2;
        GraphPoint graphPoint3 = graphPoint2 = new GraphPoint(null);
        if (hint2 instanceof PositionHint) {
            graphPoint2 = ((PositionHint)hint2).getOrigin();
            graphPoint3 = ((PositionHint)hint2).getPosition();
        }
        double d = graphPoint3.getX();
        double d2 = graphPoint3.getY();
        double d3 = graphPoint.getX() - graphPoint2.getX();
        double d4 = graphPoint.getY() - graphPoint2.getY();
        if (this._horizontalBars) {
            d4 = this._size;
            graphPoint3 = new GraphPoint(d + 0.5 * d3, graphPoint.getY() + d2);
            d += this._stacked ? d3 : 0.0;
            d2 += this._stacked ? 0.0 : this._size;
        } else {
            d3 = this._size;
            graphPoint3 = new GraphPoint(graphPoint.getX() + d, d2 + 0.5 * d4);
            d += this._stacked ? 0.0 : this._size;
            d2 += this._stacked ? d4 : 0.0;
        }
        PositionHint positionHint = new PositionHint(graphPoint2, new GraphPoint(d, d2));
        return new Symbol(new Rectangle(graphPoint3, Math.abs(d3), Math.abs(d4), graphicAttributes), hint, positionHint);
    }

    @Override
    public GraphicalElement createLegendSymbol(GraphPoint graphPoint, double d) {
        return new Rectangle(graphPoint, d, d, this._attributes);
    }

    @Override
    protected GraphicalElement createPlainSymbol(GraphPoint graphPoint, double d, GraphicAttributes graphicAttributes) {
        return null;
    }
}

