/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import java.util.Vector;
import jcckit.data.DataCurve;
import jcckit.data.DataEvent;
import jcckit.data.DataListener;
import jcckit.data.DataPlot;
import jcckit.data.DataPoint;
import jcckit.graphic.ClippingShape;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalElement;
import jcckit.plot.CartesianCoordinateSystem;
import jcckit.plot.CoordinateSystem;
import jcckit.plot.Curve;
import jcckit.plot.CurveFactory;
import jcckit.plot.Hint;
import jcckit.plot.Legend;
import jcckit.plot.PlotEvent;
import jcckit.plot.PlotEventType;
import jcckit.plot.PlotListener;
import jcckit.plot.SimpleCurveFactory;
import jcckit.transformation.Transformation;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;

public class Plot
implements DataListener {
    public static final String COORDINATE_SYSTEM_KEY = "coordinateSystem";
    public static final String CURVE_FACTORY_KEY = "curveFactory";
    public static final String LEGEND_VISIBLE_KEY = "legendVisible";
    public static final String LEGEND_KEY = "legend";
    public static final String INITIAL_HINT_FOR_NEXT_CURVE_KEY = "initialHintForNextCurve";
    private final Vector _plotListeners = new Vector();
    private DataPlot _dataPlot;
    private final CurveFactory _curveFactory;
    private final Vector _curves = new Vector();
    private final Vector _nextCurveHints = new Vector();
    private final Hint _initialHintForNextCurve;
    private final Legend _legend;
    private final boolean _legendVisibility;
    private GraphicalElement _coordinateSystemView;
    private ClippingShape _clippingShape;
    private Transformation _transformation;
    private GraphicalElement _annotation;
    private GraphicalComposite _legendView = new GraphicalComposite(null);

    public Plot(ConfigParameters configParameters) {
        CoordinateSystem coordinateSystem = (CoordinateSystem)Factory.create(configParameters.getNode(COORDINATE_SYSTEM_KEY), CartesianCoordinateSystem.class.getName());
        this.setCoordinateSystem(coordinateSystem);
        this._curveFactory = (CurveFactory)Factory.create(configParameters.getNode(CURVE_FACTORY_KEY), SimpleCurveFactory.class.getName());
        this._initialHintForNextCurve = (Hint)Factory.createOrGet(configParameters.getNode(INITIAL_HINT_FOR_NEXT_CURVE_KEY), null);
        this._legend = new Legend(configParameters.getNode(LEGEND_KEY));
        this._legendVisibility = configParameters.getBoolean(LEGEND_VISIBLE_KEY, true);
    }

    public void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        this._coordinateSystemView = coordinateSystem.getView();
        this._clippingShape = coordinateSystem.getClippingShape();
        this._transformation = coordinateSystem.getTransformation();
        if (this._dataPlot != null) {
            this.generateCurves(this._dataPlot);
        }
        this.notifyListeners(new PlotEvent(this, PlotEventType.COODINATE_SYSTEM_CHANGED, null));
    }

    public void addPlotListener(PlotListener plotListener) {
        if (!this._plotListeners.contains(plotListener)) {
            this._plotListeners.addElement(plotListener);
        }
    }

    public void removePlotListener(PlotListener plotListener) {
        this._plotListeners.removeElement(plotListener);
    }

    protected void notifyListeners(PlotEvent plotEvent) {
        int n = this._plotListeners.size();
        for (int i = 0; i < n; ++i) {
            ((PlotListener)this._plotListeners.elementAt(i)).plotChanged(plotEvent);
        }
    }

    public void connect(DataPlot dataPlot) {
        if (this._dataPlot != null) {
            this._dataPlot.removeDataListener(this);
            this.notifyListeners(new PlotEvent(this, PlotEventType.DATA_PLOT_DISCONNECTED, this._dataPlot));
        }
        this._dataPlot = dataPlot;
        if (this._dataPlot != null) {
            this._dataPlot.addDataListener(this);
            this.generateCurves(this._dataPlot);
            this.notifyListeners(new PlotEvent(this, PlotEventType.DATA_PLOT_CONNECTED, this._dataPlot));
        }
    }

    public DataPoint transform(GraphPoint graphPoint) {
        return this._transformation.transformToData(graphPoint);
    }

    public GraphicalComposite getCompletePlot() {
        GraphicalComposite graphicalComposite = new GraphicalComposite(null);
        graphicalComposite.addElement(this._coordinateSystemView);
        GraphicalElement[] graphicalElementArray = this.getCurves();
        for (int i = 0; i < graphicalElementArray.length; ++i) {
            graphicalComposite.addElement(graphicalElementArray[i]);
        }
        if (this._annotation != null) {
            graphicalComposite.addElement(this._annotation);
        }
        if (this._legendVisibility) {
            graphicalComposite.addElement(this.getLegend());
        }
        return graphicalComposite;
    }

    public GraphicalElement getCoordinateSystem() {
        return this._coordinateSystemView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicalElement[] getCurves() {
        Vector vector = this._curves;
        synchronized (vector) {
            GraphicalElement[] graphicalElementArray = new GraphicalElement[this._curves.size()];
            for (int i = 0; i < graphicalElementArray.length; ++i) {
                graphicalElementArray[i] = ((Curve)this._curves.elementAt(i)).getView();
            }
            return graphicalElementArray;
        }
    }

    public GraphicalElement getAnnotation() {
        return this._annotation;
    }

    public void setAnnotation(GraphicalElement graphicalElement) {
        this._annotation = graphicalElement;
    }

    public boolean isLegendVisible() {
        return this._legendVisibility;
    }

    public GraphicalElement getLegend() {
        return this._legendView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataChanged(DataEvent dataEvent) {
        Integer n = new Integer(0);
        PlotEventType plotEventType = PlotEventType.DATA_PLOT_CHANGED;
        Vector vector = this._curves;
        synchronized (vector) {
            int n2 = this._curves.size();
            if (dataEvent.getContainer() instanceof DataCurve && n2 == this._dataPlot.getNumberOfElements()) {
                DataCurve dataCurve = (DataCurve)dataEvent.getContainer();
                n = new Integer(dataCurve.getContainer().getIndexOf(dataCurve));
                plotEventType = PlotEventType.DATA_CURVE_CHANGED;
                this.fillCurve(n, dataCurve);
                if (n < n2 - 1) {
                    Vector vector2 = (Vector)this._nextCurveHints.elementAt(n);
                    int n3 = vector2.size();
                    for (int i = 0; i < n3; ++i) {
                        if (vector2.elementAt(i) == null) continue;
                        plotEventType = PlotEventType.DATA_PLOT_CHANGED;
                        for (int j = n + 1; j < n2; ++j) {
                            this.fillCurve(j, (DataCurve)this._dataPlot.getElement(j));
                        }
                        break;
                    }
                }
            } else {
                this.generateCurves(this._dataPlot);
            }
        }
        this.notifyListeners(new PlotEvent(this, plotEventType, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCurves(DataPlot dataPlot) {
        Vector vector = this._curves;
        synchronized (vector) {
            this._legendView = new GraphicalComposite(null);
            this._legendView.addElement(this._legend.getBox());
            this._curves.setSize(0);
            this._nextCurveHints.setSize(0);
            int n = dataPlot.getNumberOfElements();
            for (int i = 0; i < n; ++i) {
                Curve curve = this._curveFactory.create(i, n, this._clippingShape, this._legend);
                this._curves.addElement(curve);
                this._nextCurveHints.addElement(new Vector());
                DataCurve dataCurve = (DataCurve)dataPlot.getElement(i);
                this._legendView.addElement(curve.getLegendSymbol());
                this._legendView.addElement(this._legend.createCurveTitle(i, n, dataCurve.getTitle()));
                this.fillCurve(i, dataCurve);
            }
        }
    }

    private void fillCurve(int n, DataCurve dataCurve) {
        Vector vector = (Vector)this._nextCurveHints.elementAt(n);
        Curve curve = (Curve)this._curves.elementAt(n);
        curve.removeAllPoints();
        int n2 = dataCurve.getNumberOfElements();
        for (int i = 0; i < n2; ++i) {
            this.setHintForNextCurve(vector, i, curve.addPoint(this._transformation.transformToGraph((DataPoint)dataCurve.getElement(i)), this.getHintForNextCurve(n - 1, i)));
        }
    }

    private Hint getHintForNextCurve(int n, int n2) {
        Hint hint = this._initialHintForNextCurve;
        if (n >= 0) {
            Vector vector = (Vector)this._nextCurveHints.elementAt(n);
            hint = n2 < vector.size() ? (Hint)vector.elementAt(n2) : this.getHintForNextCurve(n - 1, n2);
        }
        return hint;
    }

    private void setHintForNextCurve(Vector vector, int n, Hint hint) {
        while (vector.size() <= n) {
            vector.addElement(this._initialHintForNextCurve);
        }
        vector.setElementAt(hint, n);
    }
}

