/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import java.awt.Color;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.ShapeAttributes;
import jcckit.plot.AttributesHint;
import jcckit.util.ConfigParameters;

public class ShapeAttributesHint
implements AttributesHint,
Cloneable {
    public static final String INITIAL_ATTRIBUTES_KEY = "initialAttributes";
    public static final String FILL_COLOR_HSB_INCREMENT_KEY = "fillColorHSBIncrement";
    public static final String LINE_COLOR_HSB_INCREMENT_KEY = "lineColorHSBIncrement";
    public static final String LINE_THICKNESS_INCREMENT_KEY = "lineThicknessIncrement";
    private float[] _fillColorHSB;
    private float[] _lineColorHSB;
    private double _lineThickness;
    private double[] _linePattern;
    private double[] _fillColorHSBIncrement;
    private double[] _lineColorHSBIncrement;
    private double _lineThicknessIncrement;

    private static float[] extractHSB(Color color) {
        return color == null ? null : Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    private static Color createColor(float[] fArray) {
        return fArray == null ? null : Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    private static float[] incrementColor(float[] fArray, double[] dArray) {
        float[] fArray2 = null;
        if (fArray != null) {
            fArray2 = (float[])fArray.clone();
            for (int i = 0; i < 3; ++i) {
                int n = i;
                fArray2[n] = (float)((double)fArray2[n] + dArray[i]);
            }
        }
        return fArray2;
    }

    public ShapeAttributesHint(ConfigParameters configParameters) {
        ShapeAttributes shapeAttributes = new ShapeAttributes(configParameters.getNode(INITIAL_ATTRIBUTES_KEY));
        this._fillColorHSB = ShapeAttributesHint.extractHSB(shapeAttributes.getFillColor());
        this._lineColorHSB = ShapeAttributesHint.extractHSB(shapeAttributes.getLineColor());
        this._lineThickness = shapeAttributes.getLineThickness();
        this._linePattern = shapeAttributes.getLinePattern();
        this._fillColorHSBIncrement = configParameters.getDoubleArray(FILL_COLOR_HSB_INCREMENT_KEY, new double[3]);
        this._lineColorHSBIncrement = configParameters.getDoubleArray(LINE_COLOR_HSB_INCREMENT_KEY, new double[3]);
        this._lineThicknessIncrement = configParameters.getDouble(LINE_THICKNESS_INCREMENT_KEY, 0.0);
    }

    @Override
    public AttributesHint getNextHint() {
        ShapeAttributesHint shapeAttributesHint = null;
        try {
            shapeAttributesHint = (ShapeAttributesHint)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        shapeAttributesHint._fillColorHSB = ShapeAttributesHint.incrementColor(this._fillColorHSB, this._fillColorHSBIncrement);
        shapeAttributesHint._lineColorHSB = ShapeAttributesHint.incrementColor(this._lineColorHSB, this._lineColorHSBIncrement);
        shapeAttributesHint._lineThickness = Math.max(0.0, this._lineThickness + this._lineThicknessIncrement);
        return shapeAttributesHint;
    }

    @Override
    public GraphicAttributes getAttributes() {
        return new ShapeAttributes(ShapeAttributesHint.createColor(this._fillColorHSB), ShapeAttributesHint.createColor(this._lineColorHSB), this._lineThickness, this._linePattern);
    }
}

