/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import java.awt.Color;
import jcckit.graphic.ClippingShape;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.LineAttributes;
import jcckit.graphic.Polygon;
import jcckit.graphic.ShapeAttributes;
import jcckit.plot.Curve;
import jcckit.plot.Hint;
import jcckit.plot.Legend;
import jcckit.plot.Symbol;
import jcckit.plot.SymbolFactory;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;

public class SimpleCurve
implements Curve {
    public static final String SYMBOL_FACTORY_KEY = "symbolFactory";
    public static final String WITH_LINE_KEY = "withLine";
    public static final String SOFT_CLIPPING_KEY = "softClipping";
    public static final String LINE_ATTRIBUTES_KEY = "lineAttributes";
    public static final String INITIAL_HINT_FOR_NEXT_POINT_KEY = "initialHintForNextPoint";
    private final ClippingShape _clippingShape;
    private final SymbolFactory _symbolFactory;
    private final GraphicalComposite _symbols;
    private final GraphicalComposite _completeCurve;
    private final GraphicalElement _legendSymbol;
    private final Hint _initialHintForNextPoint;
    private final Polygon _curve;
    private final boolean _softClipping;
    private Hint _hintForNextPoint;

    public SimpleCurve(ConfigParameters configParameters, int n, int n2, ClippingShape clippingShape, Legend legend) {
        this._symbolFactory = (SymbolFactory)Factory.createOrGet(configParameters.getNode(SYMBOL_FACTORY_KEY), null);
        boolean bl = configParameters.getBoolean(WITH_LINE_KEY, true);
        LineAttributes lineAttributes = (LineAttributes)Factory.createOrGet(configParameters.getNode(LINE_ATTRIBUTES_KEY), new ShapeAttributes(null, Color.getHSBColor((float)(n % 6) / 6.0f, 1.0f, 0.8f), 0.0, null));
        if (this._symbolFactory != null || bl) {
            this._clippingShape = clippingShape;
            this._completeCurve = new GraphicalComposite(null);
            if (bl) {
                GraphicalComposite graphicalComposite = new GraphicalComposite(clippingShape);
                this._curve = new Polygon(lineAttributes, false);
                graphicalComposite.addElement(this._curve);
                this._completeCurve.addElement(graphicalComposite);
            } else {
                this._curve = null;
            }
            this._softClipping = configParameters.getBoolean(SOFT_CLIPPING_KEY, true);
            if (this._symbolFactory != null) {
                this._symbols = new GraphicalComposite(this._softClipping ? null : clippingShape);
                this._completeCurve.addElement(this._symbols);
            } else {
                this._symbols = null;
            }
        } else {
            throw new IllegalArgumentException("Either a SymbolFactory must exist or withLines == true.");
        }
        this._hintForNextPoint = this._initialHintForNextPoint = (Hint)Factory.createOrGet(configParameters.getNode(INITIAL_HINT_FOR_NEXT_POINT_KEY), null);
        this._legendSymbol = legend.createSymbol(n, n2, this._symbolFactory, bl, lineAttributes);
    }

    @Override
    public GraphicalElement getView() {
        return this._completeCurve;
    }

    @Override
    public GraphicalElement getLegendSymbol() {
        return this._legendSymbol;
    }

    @Override
    public Hint addPoint(GraphPoint graphPoint, Hint hint) {
        if (this._curve != null) {
            this._curve.addPoint(graphPoint);
        }
        Hint hint2 = hint;
        if (this._symbolFactory != null) {
            Symbol symbol = this._symbolFactory.createSymbol(graphPoint, this._hintForNextPoint, hint);
            if (this._clippingShape == null || !this._softClipping || this._clippingShape.isInside(graphPoint)) {
                this._symbols.addElement(symbol.getSymbol());
            }
            this._hintForNextPoint = symbol.getHintForNextPoint();
            hint2 = symbol.getHintForNextCurve();
        }
        return hint2;
    }

    @Override
    public void removeAllPoints() {
        if (this._curve != null) {
            this._curve.removeAllPoints();
        }
        if (this._symbols != null) {
            this._symbols.removeAllElements();
        }
        this._hintForNextPoint = this._initialHintForNextPoint;
    }
}

