/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import java.util.StringTokenizer;
import jcckit.util.ConfigParameters;
import jcckit.util.TicLabelFormat;

public class TicLabelMap
implements TicLabelFormat {
    public static final String MAP_KEY = "map";
    private final MapItem[] _map;

    public TicLabelMap(ConfigParameters configParameters) {
        StringTokenizer stringTokenizer = new StringTokenizer(configParameters.get(MAP_KEY), ";");
        this._map = new MapItem[stringTokenizer.countTokens()];
        for (int i = 0; i < this._map.length; ++i) {
            String string = stringTokenizer.nextToken();
            try {
                this._map[i] = new MapItem(string.trim());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("Item '" + string + "' of " + configParameters.getFullKey(MAP_KEY) + " has an invalid number.");
            }
        }
    }

    @Override
    public String form(double d) {
        String string = "?";
        for (int i = 0; i < this._map.length; ++i) {
            if (!this._map[i].isInside(d)) continue;
            string = this._map[i].label;
            break;
        }
        return string;
    }

    private static class MapItem {
        private double _min = Double.MIN_VALUE;
        private double _max = Double.MAX_VALUE;
        private final String label;

        public MapItem(String string) {
            int n = string.indexOf(61);
            if (n < 0) {
                this.label = string;
            } else {
                this.label = string.substring(n + 1).trim();
                if ((n = (string = string.substring(0, n).trim()).indexOf(58)) < 0) {
                    this._min = new Double(string);
                    this._max = this._min == 0.0 ? Double.MIN_VALUE : this._min * 1.000001;
                    this._min *= 0.999999;
                    if (this._min > this._max) {
                        double d = this._min;
                        this._min = this._max;
                        this._max = d;
                    }
                } else {
                    this._min = new Double(string.substring(0, n));
                    this._max = new Double(string.substring(n + 1));
                }
            }
        }

        public boolean isInside(double d) {
            return d >= this._min && d < this._max;
        }
    }
}

