/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemBuilder;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.core.Diagram;

public class BlockUml {
    private final List<? extends CharSequence> data;
    private final int startLine;
    private Diagram system;
    private static final Pattern patternFilename = MyPattern.cmpile("^@start[^%s{}%g]+[%s{][%s%g]*([^%g]*?)[%s}%g]*$");

    BlockUml(String ... stringArray) {
        this(Arrays.asList(stringArray), 0);
    }

    public BlockUml(List<? extends CharSequence> list, int n) {
        this.startLine = n;
        String string = list.get(0).toString().trim();
        if (!string.startsWith("@start")) {
            throw new IllegalArgumentException();
        }
        this.data = new ArrayList<CharSequence>(list);
    }

    public String getFilename() {
        if (OptionFlags.getInstance().isWord()) {
            return null;
        }
        Matcher matcher = patternFilename.matcher(this.data.get(0).toString().trim());
        boolean bl = matcher.find();
        if (!bl) {
            return null;
        }
        String string = matcher.group(1);
        int n = string.indexOf(44);
        if (n != -1) {
            string = string.substring(0, n);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("<>|".indexOf(c) == -1) continue;
            return null;
        }
        return string;
    }

    public Diagram getDiagram() {
        if (this.system == null) {
            this.system = new PSystemBuilder().createPSystem(this.data);
        }
        return this.system;
    }

    public final int getStartLine() {
        return this.startLine;
    }
}

