/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.sourceforge.plantuml.FileWatcher;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.SourceFileReader;
import net.sourceforge.plantuml.preproc.Defines;

public class DirWatcher2 {
    private final File dir;
    private final Option option;
    private final String pattern;
    private final Map<File, FileWatcher> modifieds = new ConcurrentHashMap<File, FileWatcher>();
    private final ExecutorService executorService;

    public DirWatcher2(File file, Option option, String string) {
        this.dir = file;
        this.option = option;
        this.pattern = string;
        int n = Option.defaultNbThreads();
        this.executorService = Executors.newFixedThreadPool(n);
    }

    public Map<File, Future<List<GeneratedImage>>> buildCreatedFiles() throws IOException, InterruptedException {
        TreeMap<File, Future<List<GeneratedImage>>> treeMap = new TreeMap<File, Future<List<GeneratedImage>>>();
        if (this.dir.listFiles() != null) {
            for (final File file : this.dir.listFiles()) {
                FileWatcher fileWatcher;
                if (!file.isFile() || !this.fileToProcess(file.getName()) || (fileWatcher = this.modifieds.get(file)) != null && !fileWatcher.hasChanged()) continue;
                final SourceFileReader sourceFileReader = new SourceFileReader(new Defines(), file, this.option.getOutputDir(), this.option.getConfig(), this.option.getCharset(), this.option.getFileFormatOption());
                this.modifieds.put(file, new FileWatcher(Collections.singleton(file)));
                Future<List<GeneratedImage>> future = this.executorService.submit(new Callable<List<GeneratedImage>>(){

                    @Override
                    public List<GeneratedImage> call() throws Exception {
                        try {
                            List<GeneratedImage> list = sourceFileReader.getGeneratedImages();
                            HashSet<File> hashSet = new HashSet<File>(sourceFileReader.getIncludedFiles());
                            hashSet.add(file);
                            DirWatcher2.this.modifieds.put(file, new FileWatcher(hashSet));
                            return Collections.unmodifiableList(list);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return Collections.emptyList();
                        }
                    }
                });
                treeMap.put(file, future);
            }
        }
        return Collections.unmodifiableMap(treeMap);
    }

    private boolean fileToProcess(String string) {
        return string.matches(this.pattern);
    }

    public final File getDir() {
        return this.dir;
    }

    public void cancel() {
        this.executorService.shutdownNow();
    }

    public void waitEnd() throws InterruptedException {
        this.executorService.shutdown();
        this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }
}

