/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.html5.UGraphicHtml5;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.tikz.UGraphicTikz;
import net.sourceforge.plantuml.ugraphic.visio.UGraphicVdx;

public class FileFormatOption {
    private final FileFormat fileFormat;
    private final AffineTransform affineTransform;
    private final boolean withMetadata;
    private final boolean useRedForError;

    public FileFormatOption(FileFormat fileFormat) {
        this(fileFormat, null, true, false);
    }

    public final boolean isWithMetadata() {
        return this.withMetadata;
    }

    public FileFormatOption(FileFormat fileFormat, boolean bl) {
        this(fileFormat, null, false, false);
    }

    private FileFormatOption(FileFormat fileFormat, AffineTransform affineTransform, boolean bl, boolean bl2) {
        this.fileFormat = fileFormat;
        this.affineTransform = affineTransform;
        this.withMetadata = bl;
        this.useRedForError = bl2;
    }

    public FileFormatOption withUseRedForError() {
        return new FileFormatOption(this.fileFormat, this.affineTransform, this.withMetadata, true);
    }

    public String toString() {
        return this.fileFormat.toString() + " " + this.affineTransform;
    }

    public final FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public UGraphic2 createUGraphic(ColorMapper colorMapper, double d, Dimension2D dimension2D, HtmlColor htmlColor, boolean bl) {
        switch (this.fileFormat) {
            case PNG: {
                return this.createUGraphicPNG(colorMapper, d, dimension2D, htmlColor, bl);
            }
            case SVG: {
                return this.createUGraphicSVG(colorMapper, d, dimension2D, htmlColor, bl);
            }
            case EPS: {
                return new UGraphicEps(colorMapper, EpsStrategy.getDefault2());
            }
            case EPS_TEXT: {
                return new UGraphicEps(colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            }
            case HTML5: {
                return new UGraphicHtml5(colorMapper);
            }
            case VDX: {
                return new UGraphicVdx(colorMapper);
            }
            case LATEX: {
                return new UGraphicTikz(colorMapper);
            }
        }
        throw new UnsupportedOperationException(this.fileFormat.toString());
    }

    public UGraphic2 createUGraphic(Dimension2D dimension2D) {
        return this.createUGraphic(new ColorMapperIdentity(), 1.0, dimension2D, null, false);
    }

    private UGraphic2 createUGraphicSVG(ColorMapper colorMapper, double d, Dimension2D dimension2D, HtmlColor htmlColor, boolean bl) {
        Color color = Color.WHITE;
        if (htmlColor instanceof HtmlColorSimple) {
            color = colorMapper.getMappedColor(htmlColor);
        }
        UGraphicSvg uGraphicSvg = htmlColor instanceof HtmlColorGradient ? new UGraphicSvg(colorMapper, (HtmlColorGradient)htmlColor, false, d) : (color == null || color.equals(Color.WHITE) ? new UGraphicSvg(colorMapper, false, d) : new UGraphicSvg(colorMapper, StringUtils.getAsHtml(color), false, d));
        return uGraphicSvg;
    }

    private UGraphic2 createUGraphicPNG(ColorMapper colorMapper, double d, Dimension2D dimension2D, HtmlColor htmlColor, boolean bl) {
        Graphics2D graphics2D;
        EmptyImageBuilder emptyImageBuilder;
        Color color = Color.WHITE;
        if (htmlColor instanceof HtmlColorSimple) {
            color = colorMapper.getMappedColor(htmlColor);
        } else if (htmlColor instanceof HtmlColorTransparent) {
            color = null;
        }
        if (bl) {
            emptyImageBuilder = new EmptyImageBuilder((int)(dimension2D.getHeight() * d), (int)(dimension2D.getWidth() * d), color);
            graphics2D = emptyImageBuilder.getGraphics2D();
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.translate(-emptyImageBuilder.getBufferedImage().getHeight(), 0);
        } else {
            emptyImageBuilder = new EmptyImageBuilder((int)(dimension2D.getWidth() * d), (int)(dimension2D.getHeight() * d), color);
            graphics2D = emptyImageBuilder.getGraphics2D();
        }
        UGraphicG2d uGraphicG2d = new UGraphicG2d(colorMapper, graphics2D, d);
        uGraphicG2d.setBufferedImage(emptyImageBuilder.getBufferedImage());
        BufferedImage bufferedImage = uGraphicG2d.getBufferedImage();
        if (htmlColor instanceof HtmlColorGradient) {
            uGraphicG2d.apply(new UChangeBackColor(htmlColor)).draw(new URectangle(bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
        return uGraphicG2d;
    }

    public final boolean isUseRedForError() {
        return this.useRedForError;
    }
}

