/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.core.Diagram;

public class GeneratedImage
implements Comparable<GeneratedImage> {
    private final File pngFile;
    private final String description;
    private final BlockUml blockUml;

    public GeneratedImage(File file, String string, BlockUml blockUml) {
        this.blockUml = blockUml;
        this.pngFile = file;
        this.description = string;
    }

    public File getPngFile() {
        return this.pngFile;
    }

    public String getDescription() {
        return this.description;
    }

    public int lineErrorRaw() {
        Diagram diagram = this.blockUml.getDiagram();
        if (diagram instanceof PSystemError) {
            return ((PSystemError)diagram).getHigherErrorPosition() + this.blockUml.getStartLine();
        }
        return -1;
    }

    public String toString() {
        return this.pngFile.getAbsolutePath() + " " + this.description;
    }

    @Override
    public int compareTo(GeneratedImage generatedImage) {
        int n = this.pngFile.compareTo(generatedImage.pngFile);
        if (n != 0) {
            return n;
        }
        return this.description.compareTo(generatedImage.description);
    }

    public int hashCode() {
        return this.pngFile.hashCode() + this.description.hashCode();
    }

    public boolean equals(Object object) {
        GeneratedImage generatedImage = (GeneratedImage)object;
        return generatedImage.pngFile.equals(this.pngFile) && generatedImage.description.equals(this.description);
    }
}

