/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.PSystemUtils;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.preproc.Defines;

public class SourceFileReader2
implements ISourceFileReader {
    private final File file;
    private final File outputFile;
    private final BlockUmlBuilder builder;
    private FileFormatOption fileFormatOption;

    public SourceFileReader2(Defines defines, File file, File file2, List<String> list, String string, FileFormatOption fileFormatOption) throws IOException {
        this.file = file;
        this.fileFormatOption = fileFormatOption;
        this.outputFile = file2;
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        FileSystem.getInstance().setCurrentDir(file.getAbsoluteFile().getParentFile());
        this.builder = new BlockUmlBuilder(list, string, defines, this.getReader(string), file.getAbsoluteFile().getParentFile());
    }

    @Override
    public boolean hasError() {
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            if (!(blockUml.getDiagram() instanceof PSystemError)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<GeneratedImage> getGeneratedImages() throws IOException {
        Log.info("Reading file: " + this.file);
        ArrayList<GeneratedImage> arrayList = new ArrayList<GeneratedImage>();
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            File file = this.outputFile;
            Diagram diagram = blockUml.getDiagram();
            OptionFlags.getInstance().logData(this.file, diagram);
            for (File file2 : PSystemUtils.exportDiagrams(diagram, file, this.fileFormatOption)) {
                String string = "[" + this.file.getName() + "] " + diagram.getDescription();
                GeneratedImage generatedImage = new GeneratedImage(file2, string, blockUml);
                arrayList.add(generatedImage);
            }
        }
        Log.info("Number of image(s): " + arrayList.size());
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<String> getEncodedUrl() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Transcoder transcoder = TranscoderUtil.getDefaultTranscoder();
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            String string = blockUml.getDiagram().getSource().getPlainString();
            String string2 = transcoder.encode(string);
            arrayList.add(string2);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Reader getReader(String string) throws FileNotFoundException, UnsupportedEncodingException {
        if (string == null) {
            Log.info("Using default charset");
            return new InputStreamReader(new FileInputStream(this.file));
        }
        Log.info("Using charset " + string);
        return new InputStreamReader((InputStream)new FileInputStream(this.file), string);
    }

    public final void setFileFormatOption(FileFormatOption fileFormatOption) {
        this.fileFormatOption = fileFormatOption;
    }

    public final Set<File> getIncludedFiles() {
        return this.builder.getIncludedFiles();
    }
}

