/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.acearth;

import com.ctreber.acearth.plugins.markers.Marker;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.acearth.PSystemXearth;
import net.sourceforge.plantuml.command.PSystemBasicFactory;
import net.sourceforge.plantuml.command.regex.MyPattern;

public class PSystemXearthFactory
extends PSystemBasicFactory<PSystemXearth> {
    private final Map<String, String> config = new LinkedHashMap<String, String>();
    private final List<Marker> markers = new ArrayList<Marker>();
    private int width;
    private int height;

    @Override
    public PSystemXearth init(String string) {
        this.width = 512;
        this.height = 512;
        this.config.clear();
        this.markers.clear();
        return null;
    }

    private void extractDimension(String string) {
        Pattern pattern = MyPattern.cmpile("\\((\\d+),(\\d+)\\)");
        Matcher matcher = pattern.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            this.width = Integer.parseInt(matcher.group(1));
            this.height = Integer.parseInt(matcher.group(2));
        }
    }

    @Override
    public PSystemXearth executeLine(PSystemXearth pSystemXearth, String string) {
        if (pSystemXearth == null && string.startsWith("xearth")) {
            this.extractDimension(string);
            pSystemXearth = new PSystemXearth(this.width, this.height, this.config, this.markers);
            return pSystemXearth;
        }
        if (pSystemXearth == null) {
            return null;
        }
        if (string.startsWith("#") || string.startsWith("'")) {
            return pSystemXearth;
        }
        Pattern pattern = MyPattern.cmpile("(\\w+)[%s]*=[%s]*(.*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.config.put(matcher.group(1), matcher.group(2));
            return pSystemXearth;
        }
        try {
            Marker marker = Marker.loadMarkerFile(string);
            if (marker != null) {
                this.markers.add(marker);
                return pSystemXearth;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return null;
    }
}

