/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

public class InstructionSplit
implements Instruction {
    private final List<InstructionList> splits = new ArrayList<InstructionList>();
    private final Instruction parent;
    private final LinkRendering inlinkRendering;

    public InstructionSplit(Instruction instruction, LinkRendering linkRendering) {
        this.parent = instruction;
        this.splits.add(new InstructionList());
        this.inlinkRendering = linkRendering;
    }

    private InstructionList getLast() {
        return this.splits.get(this.splits.size() - 1);
    }

    @Override
    public void add(Instruction instruction) {
        this.getLast().add(instruction);
    }

    @Override
    public Ftile createFtile(FtileFactory ftileFactory) {
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>();
        for (InstructionList instructionList : this.splits) {
            arrayList.add(instructionList.createFtile(ftileFactory));
        }
        return ftileFactory.createSplit(arrayList);
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void splitAgain(LinkRendering linkRendering) {
        if (linkRendering != null) {
            this.getLast().setOutRendering(linkRendering);
        }
        InstructionList instructionList = new InstructionList();
        this.splits.add(instructionList);
    }

    public void endSplit(LinkRendering linkRendering) {
        if (linkRendering != null) {
            this.getLast().setOutRendering(linkRendering);
        }
    }

    @Override
    public final boolean kill() {
        return this.getLast().kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    @Override
    public void addNote(Display display, NotePosition notePosition) {
        this.getLast().addNote(display, notePosition);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return InstructionList.getSwimlanes2(this.splits);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getLast().getSwimlaneOut();
    }
}

