/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;

public class CommandActivityLong3
extends CommandMultilines2<ActivityDiagram3> {
    public CommandActivityLong3() {
        super(CommandActivityLong3.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "^(.*)(;|(?<![/|<>}\\]])(?:[/<}\\]])|(?<!\\</?\\w{1,5})(?<!\\<img[^>]{1,999})(?<!\\<\\$\\w{1,999})(?<!\\>)(?:\\>)|(?<!\\|.{1,999})(?:\\|))$";
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("COLOR", "(?::?(#\\w+[-\\\\|/]?\\w+))?"), new RegexLeaf(":"), new RegexLeaf("DATA", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public CommandExecutionResult executeNow(ActivityDiagram3 activityDiagram3, List<String> list) {
        list = StringUtils.removeEmptyColumns(list);
        RegexResult regexResult = this.getStartingPattern().matcher(list.get(0).trim());
        HtmlColor htmlColor = activityDiagram3.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0));
        BoxStyle boxStyle = BoxStyle.fromChar(this.getLastChar(list));
        this.removeStarting(list, regexResult.get("DATA", 0));
        this.removeEnding(list);
        activityDiagram3.addActivity(Display.create(list), htmlColor, boxStyle, null);
        return CommandExecutionResult.ok();
    }

    private char getLastChar(List<String> list) {
        String string = list.get(list.size() - 1);
        return string.charAt(string.length() - 1);
    }

    private void removeStarting(List<String> list, String string) {
        if (list.size() == 0) {
            return;
        }
        list.set(0, string);
    }

    private void removeEnding(List<String> list) {
        if (list.size() == 0) {
            return;
        }
        int n = list.size() - 1;
        String string = list.get(n);
        list.set(n, string.substring(0, string.length() - 1));
    }
}

