/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.Collection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMargedVertically;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileWithConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileWithSwimlanes;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;

public class FtileUtils {
    public static Ftile addConnection(Ftile ftile, Connection connection) {
        return new FtileWithConnection(ftile, connection);
    }

    public static Ftile addConnection(Ftile ftile, Collection<Connection> collection) {
        return new FtileWithConnection(ftile, collection);
    }

    public static Ftile withSwimlaneOut(Ftile ftile, Swimlane swimlane) {
        return new FtileWithSwimlanes(ftile, ftile.getSwimlaneIn(), swimlane);
    }

    public static Ftile addBottom(Ftile ftile, double d) {
        return new FtileMargedVertically(ftile, 0.0, d);
    }

    public static Ftile addVerticalMargin(Ftile ftile, double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            return ftile;
        }
        return new FtileMargedVertically(ftile, d, d2);
    }

    private static Ftile neverNull(Ftile ftile) {
        if (ftile == null) {
            return new FtileEmpty(false);
        }
        return ftile;
    }
}

