/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDecorate;
import net.sourceforge.plantuml.ugraphic.UGraphic;

class FtileWithConnection
extends FtileDecorate {
    private final List<Connection> connections = new ArrayList<Connection>();

    FtileWithConnection(Ftile ftile, Collection<Connection> collection) {
        super(ftile);
        if (collection == null || collection.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.connections.addAll(collection);
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.connections;
    }

    public FtileWithConnection(Ftile ftile, Connection connection) {
        this(ftile, Arrays.asList(connection));
        if (connection == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        this.getFtileDelegated().drawU(uGraphic);
        for (Connection connection : this.connections) {
            uGraphic.draw(connection);
        }
    }

    @Override
    public Collection<Connection> getInnerConnections() {
        ArrayList<Connection> arrayList = new ArrayList<Connection>(super.getInnerConnections());
        arrayList.addAll(this.connections);
        return Collections.unmodifiableList(this.connections);
    }
}

