/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.SnakeDirection;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.CompressionTransform;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Snake
implements UShape {
    private final List<Point2D.Double> points = new ArrayList<Point2D.Double>();
    private final UPolygon endDecoration;
    private final HtmlColor color;
    private TextBlock textBlock;
    private boolean mergeable = true;
    private Direction emphasizeDirection;

    public Snake transformX(CompressionTransform compressionTransform) {
        Snake snake = new Snake(this.color, this.endDecoration);
        snake.textBlock = this.textBlock;
        snake.mergeable = this.mergeable;
        snake.emphasizeDirection = this.emphasizeDirection;
        for (Point2D.Double double_ : this.points) {
            double d = compressionTransform.transform(double_.x);
            double d2 = double_.y;
            snake.addPoint(d, d2);
        }
        return snake;
    }

    public Snake(HtmlColor htmlColor, UPolygon uPolygon) {
        this.endDecoration = uPolygon;
        this.color = htmlColor;
    }

    public Snake(HtmlColor htmlColor) {
        this(htmlColor, null);
    }

    public void setLabel(TextBlock textBlock) {
        this.textBlock = textBlock;
    }

    public Snake move(double d, double d2) {
        Snake snake = new Snake(this.color, this.endDecoration);
        for (Point2D point2D : this.points) {
            snake.addPoint(point2D.getX() + d, point2D.getY() + d2);
        }
        snake.textBlock = this.textBlock;
        snake.mergeable = this.mergeable;
        snake.emphasizeDirection = this.emphasizeDirection;
        return snake;
    }

    public Snake translate(UTranslate uTranslate) {
        return this.move(uTranslate.getDx(), uTranslate.getDy());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            stringBuilder.append((Object)((Object)this.getDirectionAtPoint(i)) + " ");
        }
        return stringBuilder + this.points.toString();
    }

    SnakeDirection getDirection() {
        if (this.points.size() < 2) {
            throw new IllegalStateException();
        }
        return SnakeDirection.getDirection(this.points.get(0), this.points.get(1));
    }

    public void addPoint(double d, double d2) {
        this.points.add(new Point2D.Double(d, d2));
    }

    public void addPoint(Point2D point2D) {
        this.addPoint(point2D.getX(), point2D.getY());
    }

    public void drawInternal(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UChangeColor(this.color));
        uGraphic = uGraphic.apply(new UChangeBackColor(this.color));
        uGraphic = uGraphic.apply(new UStroke(1.5));
        boolean bl = false;
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D.Double double_ = this.points.get(i);
            Point2D.Double double_2 = this.points.get(i + 1);
            Line2D.Double double_3 = new Line2D.Double(double_, double_2);
            if (!bl && this.emphasizeDirection != null && Direction.fromVector(double_, double_2) == this.emphasizeDirection) {
                this.drawLine(uGraphic, double_3, this.emphasizeDirection);
                bl = true;
                continue;
            }
            this.drawLine(uGraphic, double_3, null);
        }
        if (this.endDecoration != null) {
            Point2D point2D = this.points.get(this.points.size() - 1);
            uGraphic.apply(new UTranslate(point2D)).apply(new UStroke()).draw(this.endDecoration);
        }
        if (this.textBlock != null) {
            Point2D point2D = this.getTextBlockPosition(uGraphic.getStringBounder());
            this.textBlock.drawU(uGraphic.apply(new UTranslate(point2D)));
        }
    }

    public double getMaxX(StringBounder stringBounder) {
        double d = -1.7976931348623157E308;
        for (Point2D cloneable : this.points) {
            d = Math.max(d, cloneable.getX());
        }
        if (this.textBlock != null) {
            Point2D point2D = this.getTextBlockPosition(stringBounder);
            Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
            d = Math.max(d, point2D.getX() + dimension2D.getWidth());
        }
        return d;
    }

    private Point2D getTextBlockPosition(StringBounder stringBounder) {
        Point2D point2D = this.points.get(0);
        Point2D point2D2 = this.points.get(1);
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        double d = (point2D.getY() + point2D2.getY()) / 2.0 - dimension2D.getHeight() / 2.0;
        return new Point2D.Double(Math.max(point2D.getX(), point2D2.getX()) + 4.0, d);
    }

    public List<Line2D> getHorizontalLines() {
        ArrayList<Line2D> arrayList = new ArrayList<Line2D>();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D point2D = this.points.get(i);
            Point2D point2D2 = this.points.get(i + 1);
            if (point2D.getY() != point2D2.getY()) continue;
            Line2D.Double double_ = new Line2D.Double(point2D, point2D2);
            arrayList.add(double_);
        }
        return arrayList;
    }

    private Point2D getFirst() {
        return this.points.get(0);
    }

    public Point2D getLast() {
        return this.points.get(this.points.size() - 1);
    }

    private boolean same(Point2D point2D, Point2D point2D2) {
        return point2D.distance(point2D2) < 0.001;
    }

    public Snake merge(Snake snake) {
        if (!this.mergeable || !snake.mergeable) {
            return null;
        }
        if (this.same(this.getLast(), snake.getFirst())) {
            UPolygon uPolygon = this.endDecoration == null ? snake.endDecoration : this.endDecoration;
            Snake snake2 = new Snake(this.color, uPolygon);
            snake2.textBlock = this.textBlock == null ? snake.textBlock : this.textBlock;
            snake2.emphasizeDirection = this.emphasizeDirection == null ? snake.emphasizeDirection : this.emphasizeDirection;
            snake2.points.addAll(this.points);
            snake2.points.addAll(snake.points);
            snake2.mergeMe();
            return snake2;
        }
        if (this.same(this.getFirst(), snake.getLast())) {
            return snake.merge(this);
        }
        return null;
    }

    private void mergeMe() {
        boolean bl = false;
        do {
            bl = (bl = false) || this.removeNullVector();
            bl = bl || this.removeRedondantDirection();
            bl = bl || this.removePattern1();
            bl = bl || this.removePattern2();
            bl = bl || this.removePattern3();
            bl = bl || this.removePattern4();
            bl = bl || this.removePattern5();
            bl = bl || this.removePattern6();
        } while (bl = bl || this.removePattern7());
    }

    private boolean removeNullVector() {
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Direction direction = this.getDirectionAtPoint(i);
            if (direction != null) continue;
            this.points.remove(i);
            return true;
        }
        return false;
    }

    private boolean removeRedondantDirection() {
        for (int i = 0; i < this.points.size() - 2; ++i) {
            Direction direction;
            Direction direction2 = this.getDirectionAtPoint(i);
            if (direction2 != (direction = this.getDirectionAtPoint(i + 1))) continue;
            this.points.remove(i + 1);
            return true;
        }
        return false;
    }

    private boolean removePattern1() {
        for (int i = 0; i < this.points.size() - 5; ++i) {
            List<Direction> list = this.getPatternAt(i);
            if (!Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.RIGHT).equals(list) && !Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.LEFT).equals(list)) continue;
            Point2D.Double double_ = new Point2D.Double(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, double_);
            return true;
        }
        return false;
    }

    private boolean removePattern7() {
        if (this.points.size() > 4) {
            List<Direction> list = this.getPatternAt(0);
            if (Arrays.asList(Direction.RIGHT, Direction.DOWN, Direction.LEFT, Direction.DOWN).equals(list) && this.points.get((int)3).x > this.points.get((int)0).x) {
                Point2D.Double double_ = new Point2D.Double(this.points.get((int)3).x, this.points.get((int)0).y);
                this.points.remove(2);
                this.points.remove(1);
                this.points.add(1, double_);
                return true;
            }
        }
        return false;
    }

    private boolean removePattern2() {
        for (int i = 0; i < this.points.size() - 5; ++i) {
            List<Direction> list = this.getPatternAt(i);
            if (!Arrays.asList(Direction.RIGHT, Direction.DOWN, Direction.RIGHT, Direction.UP).equals(list) && !Arrays.asList(Direction.LEFT, Direction.DOWN, Direction.LEFT, Direction.UP).equals(list)) continue;
            Point2D.Double double_ = new Point2D.Double(this.points.get((int)(i + 3)).x, this.points.get((int)(i + 1)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, double_);
            return true;
        }
        return false;
    }

    private boolean removePattern3() {
        for (int i = 0; i < this.points.size() - 4; ++i) {
            List<Direction> list = this.getPatternAt(i);
            if (!Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.RIGHT).equals(list) && !Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.LEFT).equals(list)) continue;
            Point2D.Double double_ = new Point2D.Double(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, double_);
            return true;
        }
        return false;
    }

    private boolean removePattern4() {
        int n = this.points.size() - 5;
        if (n >= 0) {
            List<Direction> list = this.getPatternAt(n);
            if (Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.RIGHT).equals(list)) {
                Point2D.Double double_ = this.points.get(n + 1);
                Point2D.Double double_2 = this.points.get(n + 4);
                if (double_2.x > double_.x) {
                    Point2D.Double double_3 = new Point2D.Double(this.points.get((int)(n + 1)).x, this.points.get((int)(n + 3)).y);
                    this.points.remove(n + 3);
                    this.points.remove(n + 2);
                    this.points.remove(n + 1);
                    this.points.add(n + 1, double_3);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean removePattern5() {
        int n = this.points.size() - 5;
        if (n >= 0) {
            List<Direction> list = this.getPatternAt(n);
            if (Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.LEFT).equals(list)) {
                Point2D.Double double_ = this.points.get(n + 1);
                Point2D.Double double_2 = this.points.get(n + 4);
                if (double_2.x < double_.x) {
                    Point2D.Double double_3 = new Point2D.Double(this.points.get((int)(n + 1)).x, this.points.get((int)(n + 3)).y);
                    this.points.remove(n + 3);
                    this.points.remove(n + 2);
                    this.points.remove(n + 1);
                    this.points.add(n + 1, double_3);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean removePattern6() {
        for (int i = 0; i < this.points.size() - 2; ++i) {
            if (!this.isForwardAndBackwardAt(i)) continue;
            this.points.remove(i + 1);
            return true;
        }
        return false;
    }

    private List<Direction> getPatternAt(int n) {
        return Arrays.asList(this.getDirectionAtPoint(n), this.getDirectionAtPoint(n + 1), this.getDirectionAtPoint(n + 2), this.getDirectionAtPoint(n + 3));
    }

    private boolean isForwardAndBackwardAt(int n) {
        return this.getDirectionAtPoint(n) == this.getDirectionAtPoint(n + 1).getInv();
    }

    private Direction getDirectionAtPoint(int n) {
        return Direction.fromVector(this.points.get(n), this.points.get(n + 1));
    }

    private void drawLine(UGraphic uGraphic, Line2D line2D, Direction direction) {
        this.drawLine(uGraphic, line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2(), direction);
    }

    private void drawLine(UGraphic uGraphic, double d, double d2, double d3, double d4, Direction direction) {
        uGraphic = uGraphic.apply(new UTranslate(d, d2));
        if (direction != null) {
            uGraphic.apply(new UTranslate((d3 - d) / 2.0, (d4 - d2) / 2.0)).draw(Arrows.asTo(direction));
        }
        uGraphic.draw(new ULine(d3 - d, d4 - d2));
    }

    public void goUnmergeable() {
        this.mergeable = false;
    }

    public void emphasizeDirection(Direction direction) {
        this.emphasizeDirection = direction;
    }
}

