/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileHeightFixed;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMarged;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileSplit1;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileFactoryDelegatorCreateSplit
extends FtileFactoryDelegator {
    private final double spaceArroundBlackBar = 20.0;
    private final double barHeight = 6.0;
    private final double xMargin = 14.0;
    private final Rose rose = new Rose();

    public FtileFactoryDelegatorCreateSplit(FtileFactory ftileFactory, ISkinParam iSkinParam) {
        super(ftileFactory, iSkinParam);
    }

    private static boolean isSimpleSwimlanes(List<Ftile> list) {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        for (Ftile ftile : list) {
            Set<Swimlane> set = ftile.getSwimlanes();
            if (set.size() != 1) {
                return false;
            }
            assert (set.size() == 1);
            Swimlane swimlane = set.iterator().next();
            if (hashSet.contains(swimlane)) {
                return false;
            }
            hashSet.add(swimlane);
        }
        return hashSet.size() > 1;
    }

    private static boolean isSeveralSwimlanes(List<Ftile> list) {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        for (Ftile ftile : list) {
            Set<Swimlane> set = ftile.getSwimlanes();
            if (set.size() > 1) {
                return true;
            }
            assert (set.size() == 0 || set.size() == 1);
            if (set.size() != 1) continue;
            Swimlane swimlane = set.iterator().next();
            hashSet.add(swimlane);
        }
        return hashSet.size() > 1;
    }

    @Override
    public Ftile createSplit(List<Ftile> list) {
        HtmlColor htmlColor = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.activityArrow);
        FtileGeometry ftileGeometry = super.createSplit(list).calculateDimension(this.getStringBounder());
        double d = ((Dimension2D)ftileGeometry).getHeight() + 40.0;
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>();
        for (Ftile object2 : list) {
            arrayList.add(new FtileHeightFixed(new FtileMarged(object2, 14.0), d));
        }
        Object object3 = super.createSplit(arrayList);
        ArrayList<Connection> arrayList2 = new ArrayList<Connection>();
        double d2 = 0.0;
        boolean bl = false;
        for (Ftile ftile : arrayList) {
            FtileGeometry ftileGeometry2 = ftile.calculateDimension(this.getStringBounder());
            arrayList2.add(new ConnectionIn(ftile, d2, htmlColor, this.getTextBlock(ftile.getInLinkRendering())));
            boolean bl2 = ftile.calculateDimension(this.getStringBounder()).hasPointOut();
            if (bl2) {
                arrayList2.add(new ConnectionOut(ftile, d2, htmlColor, d, this.getTextBlock(ftile.getOutLinkRendering())));
                bl = true;
            }
            d2 += ((Dimension2D)ftileGeometry2).getWidth();
        }
        double d3 = object3.calculateDimension(this.getStringBounder()).getWidth();
        arrayList2.add(new ConnectionHline2((Ftile)object3, htmlColor, 0.0, arrayList, d3));
        if (bl) {
            arrayList2.add(new ConnectionHline2((Ftile)object3, htmlColor, d, arrayList, d3));
        }
        object3 = FtileUtils.addConnection((Ftile)object3, arrayList2);
        if (!bl) {
            object3 = new FtileKilled((Ftile)object3);
        }
        return object3;
    }

    private TextBlock getTextBlock(LinkRendering linkRendering) {
        Display display = LinkRendering.getDisplay(linkRendering);
        if (display == null) {
            return null;
        }
        ISkinParam iSkinParam = this.getSkinParam();
        UFont uFont = iSkinParam.getFont(FontParam.ACTIVITY_ARROW, null, false);
        HtmlColor htmlColor = this.rose.getFontColor(iSkinParam, FontParam.ACTIVITY_ARROW);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, htmlColor, iSkinParam.getHyperlinkColor(), iSkinParam.useUnderlineForHyperlink());
        return TextBlockUtils.create(display, fontConfiguration, HorizontalAlignment.LEFT, null, true);
    }

    private Ftile simpleSwimlanes(List<Ftile> list) {
        HtmlColor htmlColor = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.activityArrow);
        FtileGeometry ftileGeometry = new FtileSplit1(list).calculateDimension(this.getStringBounder());
        double d = ((Dimension2D)ftileGeometry).getHeight() + 40.0;
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>();
        for (Ftile object2 : list) {
            arrayList.add(new FtileHeightFixed(new FtileMarged(object2, 14.0), d));
        }
        Object object3 = new FtileSplit1(arrayList);
        ArrayList<Connection> arrayList2 = new ArrayList<Connection>();
        boolean bl = false;
        for (Ftile ftile : arrayList) {
            double d2 = object3.getTranslateFor(ftile, this.getStringBounder()).getDx();
            arrayList2.add(new ConnectionIn(ftile, d2, htmlColor, null));
            boolean bl2 = ftile.calculateDimension(this.getStringBounder()).hasPointOut();
            if (!bl2) continue;
            arrayList2.add(new ConnectionOut(ftile, d2, htmlColor, d, null));
            bl = true;
        }
        double d3 = object3.calculateDimension(this.getStringBounder()).getWidth();
        arrayList2.add(new ConnectionHline3((Ftile)object3, htmlColor, 0.0, arrayList, d3));
        if (bl) {
            arrayList2.add(new ConnectionHline3((Ftile)object3, htmlColor, d, arrayList, d3));
        }
        object3 = FtileUtils.addConnection((Ftile)object3, arrayList2);
        if (!bl) {
            object3 = new FtileKilled((Ftile)object3);
        }
        return object3;
    }

    static class ConnectionOut
    extends AbstractConnection {
        private final double x;
        private final HtmlColor arrowColor;
        private final double height;
        private final TextBlock text;

        public ConnectionOut(Ftile ftile, double d, HtmlColor htmlColor, double d2, TextBlock textBlock) {
            super(ftile, null);
            this.x = d;
            this.arrowColor = htmlColor;
            this.height = d2;
            this.text = textBlock;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(uGraphic.getStringBounder());
            if (!ftileGeometry.hasPointOut()) {
                assert (false);
                return;
            }
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.setLabel(this.text);
            snake.goUnmergeable();
            snake.addPoint(ftileGeometry.getLeft(), ftileGeometry.getOutY());
            snake.addPoint(ftileGeometry.getLeft(), this.height);
            uGraphic.draw(snake);
        }
    }

    static class ConnectionIn
    extends AbstractConnection {
        private final double x;
        private final HtmlColor arrowColor;
        private final TextBlock text;

        public ConnectionIn(Ftile ftile, double d, HtmlColor htmlColor, TextBlock textBlock) {
            super(null, ftile);
            this.x = d;
            this.arrowColor = htmlColor;
            this.text = textBlock;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            FtileGeometry ftileGeometry = this.getFtile2().calculateDimension(uGraphic.getStringBounder());
            double d = ftileGeometry.getLeft();
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.setLabel(this.text);
            snake.addPoint(d, 0.0);
            snake.addPoint(d, ftileGeometry.getInY());
            uGraphic.draw(snake);
        }
    }

    static class ConnectionHline3
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Ftile inner;
        private final double y;
        private final HtmlColor arrowColor;
        private final List<Ftile> list;
        private final double totalWidth;

        public ConnectionHline3(Ftile ftile, HtmlColor htmlColor, double d, List<Ftile> list, double d2) {
            super(null, null);
            this.inner = ftile;
            this.y = d;
            this.arrowColor = htmlColor;
            this.list = list;
            this.totalWidth = d2;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            double d;
            StringBounder stringBounder = uGraphic.getStringBounder();
            UTranslate uTranslate3 = this.inner.getSwimlaneIn().getTranslate();
            double d2 = d = this.inner.calculateDimension(stringBounder).getLeft() + uTranslate3.getDx();
            for (Ftile uShape2 : this.list) {
                FtileGeometry ftileGeometry = uShape2.calculateDimension(stringBounder);
                UTranslate uTranslate4 = this.inner.getTranslateFor(uShape2, stringBounder);
                for (Swimlane swimlane : uShape2.getSwimlanes()) {
                    double d3 = ftileGeometry.translate(swimlane.getTranslate().compose(uTranslate4)).getLeft();
                    d = Math.min(d, d3);
                    d2 = Math.max(d2, d3);
                }
            }
            FtileGeometry ftileGeometry = this.inner.calculateDimension(stringBounder);
            Snake snake = new Snake(this.arrowColor);
            snake.goUnmergeable();
            snake.addPoint(d, this.y);
            snake.addPoint(d2, this.y);
            uGraphic.draw(snake);
        }
    }

    static class ConnectionHline2
    extends AbstractConnection {
        private final Ftile inner;
        private final double y;
        private final HtmlColor arrowColor;
        private final List<Ftile> list;
        private final double totalWidth;

        public ConnectionHline2(Ftile ftile, HtmlColor htmlColor, double d, List<Ftile> list, double d2) {
            super(null, null);
            this.inner = ftile;
            this.y = d;
            this.arrowColor = htmlColor;
            this.list = list;
            this.totalWidth = d2;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            double d = Double.MAX_VALUE;
            double d2 = 0.0;
            StringBounder stringBounder = uGraphic.getStringBounder();
            for (Ftile ftile : this.list) {
                UTranslate uTranslate;
                if (this.y > 0.0 && !ftile.calculateDimension(stringBounder).hasPointOut() || (uTranslate = this.inner.getTranslateFor(ftile, stringBounder)) == null) continue;
                double d3 = ftile.calculateDimension(stringBounder).translate(uTranslate).getLeft();
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
            if (d > this.totalWidth / 2.0) {
                d = this.totalWidth / 2.0;
            }
            if (d2 < this.totalWidth / 2.0) {
                d2 = this.totalWidth / 2.0;
            }
            Snake snake = new Snake(this.arrowColor);
            snake.goUnmergeable();
            snake.addPoint(d, this.y);
            snake.addPoint(d2, this.y);
            uGraphic.draw(snake);
        }
    }
}

