/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class FtileIf
extends AbstractFtile {
    private final Ftile tile1;
    private final Ftile tile2;
    private final Ftile diamond1;
    private final Ftile diamond2;
    private final HtmlColor arrowColor;
    private Dimension2D calculateDimensionInternal;

    private FtileIf(Ftile ftile, Ftile ftile2, Ftile ftile3, Ftile ftile4, HtmlColor htmlColor) {
        super(ftile2.shadowing() || ftile3.shadowing());
        this.diamond1 = ftile;
        this.diamond2 = ftile4;
        this.tile1 = ftile2;
        this.tile2 = ftile3;
        this.arrowColor = htmlColor;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            hashSet.add(this.getSwimlaneIn());
        }
        hashSet.addAll(this.tile1.getSwimlanes());
        hashSet.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.diamond1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    static Ftile create(Swimlane swimlane, HtmlColor htmlColor, HtmlColor htmlColor2, UFont uFont, UFont uFont2, HtmlColor htmlColor3, FtileFactory ftileFactory, ConditionStyle conditionStyle, Branch branch, Branch branch2, ISkinParam iSkinParam, StringBounder stringBounder) {
        AbstractFtile abstractFtile;
        Object object;
        Object object2;
        AbstractFtile abstractFtile2;
        Display display = branch.getLabelTest();
        FtileMinWidth ftileMinWidth = new FtileMinWidth(branch.getFtile(), 30.0);
        FtileMinWidth ftileMinWidth2 = new FtileMinWidth(branch2.getFtile(), 30.0);
        HtmlColor htmlColor4 = iSkinParam.getFontHtmlColor(FontParam.ACTIVITY_DIAMOND, null);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, htmlColor4, iSkinParam.getHyperlinkColor(), iSkinParam.useUnderlineForHyperlink());
        FontConfiguration fontConfiguration2 = new FontConfiguration(uFont2, htmlColor4, iSkinParam.getHyperlinkColor(), iSkinParam.useUnderlineForHyperlink());
        TextBlock textBlock = TextBlockUtils.create(branch.getLabelPositive(), fontConfiguration, HorizontalAlignment.LEFT, ftileFactory, true);
        TextBlock textBlock2 = TextBlockUtils.create(branch2.getLabelPositive(), fontConfiguration, HorizontalAlignment.LEFT, ftileFactory, true);
        Sheet sheet = new CreoleParser(fontConfiguration2, HorizontalAlignment.LEFT, iSkinParam, false).createSheet(display);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, 0.0, iSkinParam.getPadding());
        SheetBlock2 sheetBlock2 = new SheetBlock2(sheetBlock1, Diamond.asStencil(sheetBlock1), new UStroke(1.5));
        if (conditionStyle == ConditionStyle.INSIDE) {
            abstractFtile2 = new FtileDiamondInside(ftileMinWidth.shadowing(), htmlColor2, htmlColor, swimlane, sheetBlock2).withWest(textBlock).withEast(textBlock2);
        } else if (conditionStyle == ConditionStyle.DIAMOND) {
            abstractFtile2 = new FtileDiamond(ftileMinWidth.shadowing(), htmlColor2, htmlColor, swimlane).withWest(textBlock).withEast(textBlock2).withNorth(sheetBlock2);
        } else {
            throw new IllegalStateException();
        }
        if (ftileMinWidth.calculateDimension(stringBounder).hasPointOut() && ftileMinWidth2.calculateDimension(stringBounder).hasPointOut()) {
            object2 = LinkRendering.getDisplay(branch.getFtile().getOutLinkRendering());
            object = object2 == null ? null : TextBlockUtils.create((Display)object2, fontConfiguration, HorizontalAlignment.LEFT, ftileFactory, true);
            Display display2 = LinkRendering.getDisplay(branch2.getFtile().getOutLinkRendering());
            TextBlock textBlock3 = display2 == null ? null : TextBlockUtils.create(display2, fontConfiguration, HorizontalAlignment.LEFT, ftileFactory, true);
            abstractFtile = new FtileDiamond(ftileMinWidth.shadowing(), htmlColor2, htmlColor, swimlane).withWest((TextBlock)object).withEast(textBlock3);
        } else {
            abstractFtile = new FtileEmpty(ftileMinWidth.shadowing(), 24.0, 24.0, swimlane, swimlane);
        }
        object2 = new FtileIf(abstractFtile2, ftileMinWidth, ftileMinWidth2, abstractFtile, htmlColor3);
        object = new ArrayList();
        Object object3 = object2;
        object3.getClass();
        object.add((FtileIf)object3.new ConnectionHorizontalThenVertical(ftileMinWidth, branch));
        Object object4 = object2;
        object4.getClass();
        object.add((FtileIf)object4.new ConnectionHorizontalThenVertical(ftileMinWidth2, branch2));
        if (ftileMinWidth.calculateDimension(stringBounder).hasPointOut() && ftileMinWidth2.calculateDimension(stringBounder).hasPointOut()) {
            Object object5 = object2;
            object5.getClass();
            object.add((FtileIf)object5.new ConnectionVerticalThenHorizontal(ftileMinWidth, branch.getInlinkRenderingColor(), branch.isEmpty()));
            Object object6 = object2;
            object6.getClass();
            object.add((FtileIf)object6.new ConnectionVerticalThenHorizontal(ftileMinWidth2, branch2.getInlinkRenderingColor(), branch2.isEmpty()));
        } else if (ftileMinWidth.calculateDimension(stringBounder).hasPointOut() && !ftileMinWidth2.calculateDimension(stringBounder).hasPointOut()) {
            Object object7 = object2;
            object7.getClass();
            object.add((FtileIf)object7.new ConnectionVerticalThenHorizontalDirect(ftileMinWidth, branch.getInlinkRenderingColor(), branch.isEmpty()));
        } else if (!ftileMinWidth.calculateDimension(stringBounder).hasPointOut() && ftileMinWidth2.calculateDimension(stringBounder).hasPointOut()) {
            Object object8 = object2;
            object8.getClass();
            object.add((FtileIf)object8.new ConnectionVerticalThenHorizontalDirect(ftileMinWidth2, branch2.getInlinkRenderingColor(), branch2.isEmpty()));
        }
        return FtileUtils.addConnection((Ftile)object2, (Collection<Connection>)object);
    }

    private HtmlColor getInColor(Branch branch) {
        if (branch.isEmpty()) {
            return LinkRendering.getColor(branch.getFtile().getOutLinkRendering(), this.arrowColor);
        }
        LinkRendering linkRendering = branch.getFtile().getInLinkRendering();
        HtmlColor htmlColor = linkRendering == null ? this.arrowColor : linkRendering.getColor();
        return htmlColor;
    }

    private UTranslate getTranslate1(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.tile1.calculateDimension(stringBounder);
        double d = ((Dimension2D)ftileGeometry).getHeight();
        double d2 = d * 1.9;
        return new UTranslate(0.0, d2);
    }

    private UTranslate getTranslate2(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.tile2.calculateDimension(stringBounder);
        double d = dimension2D.getWidth() - ((Dimension2D)ftileGeometry2).getWidth();
        double d2 = ((Dimension2D)ftileGeometry).getHeight();
        double d3 = d2 * 1.9;
        return new UTranslate(d, d3);
    }

    private UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        double d = this.getLeft(stringBounder) - ((Dimension2D)ftileGeometry).getWidth() / 2.0;
        return new UTranslate(d, 0.0);
    }

    private UTranslate getTranslateDiamond2(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry = this.diamond2.calculateDimension(stringBounder);
        double d = dimension2D.getHeight() - ((Dimension2D)ftileGeometry).getHeight();
        double d2 = this.getLeft(stringBounder) - ((Dimension2D)ftileGeometry).getWidth() / 2.0;
        return new UTranslate(d2, d);
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.diamond1) {
            return this.getTranslateDiamond1(stringBounder);
        }
        if (ftile == this.tile1) {
            return this.getTranslate1(stringBounder);
        }
        if (ftile == this.tile2) {
            return this.getTranslate2(stringBounder);
        }
        if (ftile == this.diamond2) {
            return this.getTranslateDiamond2(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        uGraphic.apply(this.getTranslate1(stringBounder)).draw(this.tile1);
        uGraphic.apply(this.getTranslate2(stringBounder)).draw(this.tile2);
        uGraphic.apply(this.getTranslateDiamond2(stringBounder)).draw(this.diamond2);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        if (this.tile1.calculateDimension(stringBounder).hasPointOut() || this.tile2.calculateDimension(stringBounder).hasPointOut()) {
            return new FtileGeometry(dimension2D, this.getLeft(stringBounder), 0.0, dimension2D.getHeight());
        }
        return new FtileGeometry(dimension2D, this.getLeft(stringBounder), 0.0);
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        if (this.calculateDimensionInternal == null) {
            this.calculateDimensionInternal = this.calculateDimensionInternalSlow(stringBounder);
        }
        return this.calculateDimensionInternal;
    }

    private Dimension2D calculateDimensionInternalSlow(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.tile1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.tile2.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry3 = this.diamond1.calculateDimension(stringBounder);
        double d = Math.max(((Dimension2D)ftileGeometry3).getWidth(), ftileGeometry.getWidth() - ftileGeometry.getLeft() + ftileGeometry2.getLeft() + 10.0);
        double d2 = ftileGeometry.getLeft() + d + (ftileGeometry2.getWidth() - ftileGeometry2.getLeft());
        Dimension2D dimension2D = Dimension2DDouble.mergeLR(ftileGeometry, ftileGeometry2);
        return new Dimension2DDouble(d2 + 30.0, dimension2D.getHeight() + ((Dimension2D)ftileGeometry3).getHeight() * 3.0 + 30.0);
    }

    private double getLeft(StringBounder stringBounder) {
        double d = this.tile1.calculateDimension(stringBounder).translate(this.getTranslate1(stringBounder)).getLeft();
        double d2 = this.tile2.calculateDimension(stringBounder).translate(this.getTranslate2(stringBounder)).getLeft();
        return (d + d2) / 2.0;
    }

    class ConnectionVerticalThenHorizontalDirect
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final HtmlColor myArrowColor;
        private final boolean branchEmpty;

        public ConnectionVerticalThenHorizontalDirect(Ftile ftile, HtmlColor htmlColor, boolean bl) {
            super(ftile, FtileIf.this.diamond2);
            this.myArrowColor = htmlColor == null ? FtileIf.this.arrowColor : htmlColor;
            this.branchEmpty = bl;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Dimension2D dimension2D = FtileIf.this.calculateDimensionInternal(stringBounder);
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Point2D point2D = ftileGeometry.translate(this.translate(stringBounder)).getPointOut();
            Point2D.Double double_ = new Point2D.Double(FtileIf.this.getLeft(stringBounder), dimension2D.getHeight() - 12.0);
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = ((Point2D)double_).getX();
            double d4 = ((Point2D)double_).getY();
            Snake snake = new Snake(this.myArrowColor);
            if (this.branchEmpty) {
                snake.emphasizeDirection(Direction.DOWN);
            }
            snake.addPoint(d, d2);
            snake.addPoint(d, d4);
            snake.addPoint(d3, d4);
            snake.addPoint(d3, dimension2D.getHeight());
            uGraphic.draw(snake);
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile1() == FtileIf.this.tile1) {
                return FtileIf.this.getTranslate1(stringBounder);
            }
            if (this.getFtile1() == FtileIf.this.tile2) {
                return FtileIf.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }

        @Override
        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Dimension2D dimension2D = FtileIf.this.calculateDimensionInternal(stringBounder);
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Point2D point2D = ftileGeometry.translate(this.translate(stringBounder)).getPointOut();
            Point2D.Double double_ = new Point2D.Double(FtileIf.this.getLeft(stringBounder), dimension2D.getHeight() - 12.0);
            Point2D point2D2 = uTranslate.getTranslated(point2D);
            Point2D point2D3 = uTranslate2.getTranslated(double_);
            Snake snake = new Snake(this.myArrowColor);
            double d = point2D2.getX();
            double d2 = point2D3.getX();
            double d3 = point2D3.getY();
            snake.addPoint(point2D2);
            snake.addPoint(d, d3);
            snake.addPoint(point2D3);
            snake.addPoint(d2, dimension2D.getHeight());
            uGraphic.draw(snake);
        }
    }

    class ConnectionVerticalThenHorizontal
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final HtmlColor myArrowColor;
        private final boolean branchEmpty;

        public ConnectionVerticalThenHorizontal(Ftile ftile, HtmlColor htmlColor, boolean bl) {
            super(ftile, FtileIf.this.diamond2);
            this.myArrowColor = htmlColor == null ? FtileIf.this.arrowColor : htmlColor;
            this.branchEmpty = bl;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Point2D point2D = ftileGeometry.translate(this.translate(stringBounder)).getPointOut();
            Point2D point2D2 = this.getP2(stringBounder);
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = point2D2.getX();
            double d4 = point2D2.getY();
            UPolygon uPolygon = d3 > d ? Arrows.asToRight() : Arrows.asToLeft();
            Snake snake = new Snake(this.myArrowColor, uPolygon);
            if (this.branchEmpty) {
                snake.emphasizeDirection(Direction.DOWN);
            }
            snake.addPoint(d, d2);
            snake.addPoint(d, d4);
            snake.addPoint(d3, d4);
            uGraphic.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            UPolygon uPolygon;
            StringBounder stringBounder = uGraphic.getStringBounder();
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Point2D point2D = this.getP2(stringBounder);
            Point2D point2D2 = ftileGeometry.translate(this.translate(stringBounder)).getPointOut();
            Direction direction = Direction.leftOrRight(point2D2, point2D);
            double d = point2D2.getX();
            double d2 = point2D.getX();
            Point2D point2D3 = uTranslate.getTranslated(point2D2);
            Point2D point2D4 = uTranslate2.getTranslated(point2D);
            Direction direction2 = Direction.leftOrRight(point2D3, point2D4);
            UPolygon uPolygon2 = uPolygon = d2 > d ? Arrows.asToRight() : Arrows.asToLeft();
            if (direction == direction2) {
                double d3 = (double)(d2 > d ? -1 : 1) * 1.5 * 12.0;
                Point2D.Double double_ = new Point2D.Double(point2D4.getX() + d3, point2D4.getY());
                Snake snake = new Snake(this.myArrowColor);
                double d4 = (point2D3.getY() + point2D4.getY()) / 2.0;
                snake.addPoint(point2D3);
                snake.addPoint(point2D3.getX(), d4);
                snake.addPoint(((Point2D)double_).getX(), d4);
                snake.addPoint(double_);
                uGraphic.draw(snake);
                Snake snake2 = new Snake(this.myArrowColor, uPolygon);
                snake2.addPoint(double_);
                snake2.addPoint(((Point2D)double_).getX(), point2D4.getY());
                snake2.addPoint(point2D4);
                uGraphic.draw(snake2);
            } else {
                double d5 = (double)(d2 > d ? -1 : 1) * 1.5 * 12.0;
                Point2D.Double double_ = new Point2D.Double(point2D4.getX() + d5, point2D4.getY() - 36.0);
                Snake snake = new Snake(this.myArrowColor);
                snake.addPoint(point2D3);
                snake.addPoint(point2D3.getX(), ((Point2D)double_).getY());
                snake.addPoint(double_);
                uGraphic.draw(snake);
                Snake snake3 = new Snake(this.myArrowColor, uPolygon);
                snake3.addPoint(double_);
                snake3.addPoint(((Point2D)double_).getX(), point2D4.getY());
                snake3.addPoint(point2D4);
                uGraphic.draw(snake3);
            }
        }

        private Point2D getP2(StringBounder stringBounder) {
            double d;
            FtileGeometry ftileGeometry = FtileIf.this.diamond2.calculateDimension(stringBounder);
            double d2 = ((Dimension2D)ftileGeometry).getWidth();
            if (this.getFtile1() == FtileIf.this.tile1) {
                d = 0.0;
            } else if (this.getFtile1() == FtileIf.this.tile2) {
                d = d2;
            } else {
                throw new IllegalStateException();
            }
            return FtileIf.this.getTranslateDiamond2(stringBounder).getTranslated(new Point2D.Double(d, ((Dimension2D)ftileGeometry).getHeight() / 2.0));
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile1() == FtileIf.this.tile1) {
                return FtileIf.this.getTranslate1(stringBounder);
            }
            if (this.getFtile1() == FtileIf.this.tile2) {
                return FtileIf.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }
    }

    class ConnectionHorizontalThenVertical
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final HtmlColor color;
        private final UPolygon usingArrow;

        public ConnectionHorizontalThenVertical(Ftile ftile, Branch branch) {
            super(FtileIf.this.diamond1, ftile);
            this.color = FtileIf.this.getInColor(branch);
            this.usingArrow = branch.isEmpty() ? null : Arrows.asToDown();
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = point2D2.getX();
            double d4 = point2D2.getY();
            Snake snake = new Snake(this.color, this.usingArrow);
            snake.addPoint(d, d2);
            snake.addPoint(d3, d2);
            snake.addPoint(d3, d4);
            uGraphic.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            Direction direction;
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Direction direction2 = Direction.leftOrRight(point2D, point2D2);
            if (direction2 != (direction = Direction.leftOrRight(point2D = uTranslate.getTranslated(point2D), point2D2 = uTranslate2.getTranslated(point2D2)))) {
                double d = (double)(direction2 == Direction.RIGHT ? -1 : 1) * 12.0;
                FtileGeometry ftileGeometry = FtileIf.this.diamond1.calculateDimension(stringBounder);
                Snake snake = new Snake(this.color);
                snake.addPoint(point2D);
                snake.addPoint(point2D.getX() + d, point2D.getY());
                snake.addPoint(point2D.getX() + d, point2D.getY() + ((Dimension2D)ftileGeometry).getHeight() * 0.75);
                uGraphic.draw(snake);
                point2D = snake.getLast();
            }
            Snake snake = new Snake(this.color, this.usingArrow);
            snake.addPoint(point2D);
            snake.addPoint(point2D2.getX(), point2D.getY());
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            double d;
            FtileGeometry ftileGeometry = FtileIf.this.diamond1.calculateDimension(stringBounder);
            double d2 = ((Dimension2D)ftileGeometry).getWidth();
            if (this.getFtile2() == FtileIf.this.tile1) {
                d = 0.0;
            } else if (this.getFtile2() == FtileIf.this.tile2) {
                d = d2;
            } else {
                throw new IllegalStateException();
            }
            return FtileIf.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(d, ((Dimension2D)ftileGeometry).getHeight() / 2.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            return this.translate(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        private UTranslate translate(StringBounder stringBounder) {
            if (this.getFtile2() == FtileIf.this.tile1) {
                return FtileIf.this.getTranslate1(stringBounder);
            }
            if (this.getFtile2() == FtileIf.this.tile2) {
                return FtileIf.this.getTranslate2(stringBounder);
            }
            throw new IllegalStateException();
        }
    }
}

