/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class FtileIfLong
extends AbstractFtile {
    private final double xSeparation = 20.0;
    private final List<Ftile> tiles;
    private final Ftile tile2;
    private final List<Ftile> diamonds;
    private final HtmlColor arrowColor;

    private FtileIfLong(List<Ftile> list, List<Ftile> list2, Ftile ftile, HtmlColor htmlColor) {
        super(list2.get(0).shadowing() || ftile.shadowing());
        this.diamonds = list;
        this.tiles = list2;
        this.tile2 = ftile;
        this.arrowColor = htmlColor;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            hashSet.add(this.getSwimlaneIn());
        }
        for (Ftile ftile : this.tiles) {
            hashSet.addAll(ftile.getSwimlanes());
        }
        hashSet.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.diamonds.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    static Ftile create(Swimlane swimlane, HtmlColor htmlColor, HtmlColor htmlColor2, UFont uFont, HtmlColor htmlColor3, FtileFactory ftileFactory, ConditionStyle conditionStyle, List<Branch> list, Branch branch, HtmlColor htmlColor4, boolean bl) {
        Ftile ftile;
        int n;
        Ftile ftile2;
        TextBlock textBlock;
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>();
        for (Branch object2 : list) {
            arrayList.add(new FtileMinWidth(object2.getFtile(), 30.0));
        }
        FtileMinWidth ftileMinWidth = new FtileMinWidth(branch.getFtile(), 30.0);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK, htmlColor4, bl);
        ArrayList<Ftile> arrayList2 = new ArrayList<Ftile>();
        ArrayList<Connection> arrayList3 = new ArrayList<Connection>();
        for (Branch n2 : list) {
            textBlock = TextBlockUtils.create(n2.getLabelPositive(), fontConfiguration, HorizontalAlignment.LEFT, ftileFactory);
            TextBlock n3 = TextBlockUtils.create(n2.getLabelTest(), fontConfiguration, HorizontalAlignment.LEFT, ftileFactory);
            ftile2 = new FtileDiamondInside(n2.shadowing(), htmlColor2, htmlColor, swimlane, n3);
            ftile2 = ftile2.withNorth(textBlock);
            arrayList2.add(ftile2);
        }
        TextBlock textBlock2 = TextBlockUtils.create(branch.getLabelPositive(), fontConfiguration, HorizontalAlignment.LEFT, ftileFactory);
        int n4 = arrayList2.size() - 1;
        arrayList2.set(n4, ((FtileDiamondInside)arrayList2.get(n4)).withEast(textBlock2));
        textBlock = new FtileIfLong(arrayList2, arrayList, ftileMinWidth, htmlColor3);
        for (n = 0; n < list.size(); ++n) {
            ftile2 = (Ftile)arrayList.get(n);
            ftile = (Ftile)arrayList2.get(n);
            HtmlColor htmlColor5 = list.get(n).getInlinkRenderingColor();
            TextBlock textBlock3 = textBlock;
            textBlock3.getClass();
            arrayList3.add((FtileIfLong)textBlock3.new ConnectionVerticalIn(ftile, ftile2, htmlColor5 == null ? htmlColor3 : htmlColor5));
            TextBlock textBlock4 = textBlock;
            textBlock4.getClass();
            arrayList3.add((FtileIfLong)textBlock4.new ConnectionVerticalOut(ftile2, htmlColor3));
        }
        for (n = 0; n < arrayList2.size() - 1; ++n) {
            ftile2 = (Ftile)arrayList2.get(n);
            ftile = (Ftile)arrayList2.get(n + 1);
            TextBlock textBlock5 = textBlock;
            textBlock5.getClass();
            arrayList3.add((FtileIfLong)textBlock5.new ConnectionHorizontal(ftile2, ftile, htmlColor3));
        }
        TextBlock textBlock6 = textBlock;
        textBlock6.getClass();
        arrayList3.add((FtileIfLong)textBlock6.new ConnectionIn(htmlColor3));
        TextBlock textBlock7 = textBlock;
        textBlock7.getClass();
        arrayList3.add((FtileIfLong)textBlock7.new ConnectionLastElseIn(htmlColor3));
        TextBlock textBlock8 = textBlock;
        textBlock8.getClass();
        arrayList3.add((FtileIfLong)textBlock8.new ConnectionLastElseOut(htmlColor3));
        TextBlock textBlock9 = textBlock;
        textBlock9.getClass();
        arrayList3.add((FtileIfLong)textBlock9.new ConnectionHline(htmlColor3));
        return FtileUtils.addConnection((Ftile)textBlock, arrayList3);
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.tile2) {
            return this.getTranslate2(stringBounder);
        }
        if (this.tiles.contains(ftile)) {
            return this.getTranslate1(ftile, stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslate2(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry = this.tile2.calculateDimension(stringBounder);
        double d = dimension2D.getWidth() - ((Dimension2D)ftileGeometry).getWidth();
        double d2 = this.getAllDiamondsHeight(stringBounder);
        double d3 = (dimension2D.getHeight() - d2 * 2.0 - ((Dimension2D)ftileGeometry).getHeight()) / 2.0 + d2;
        return new UTranslate(d, d3);
    }

    private UTranslate getTranslateDiamond1(Ftile ftile, StringBounder stringBounder) {
        double d = 0.0;
        for (Ftile ftile2 : this.diamonds) {
            FtileGeometry ftileGeometry = this.dimDiamondAndTile(stringBounder, ftile2);
            if (ftile2 == ftile) {
                FtileGeometry ftileGeometry2 = ftile2.calculateDimension(stringBounder);
                double d2 = d + ftileGeometry.getLeft() - ftileGeometry2.getLeft();
                return new UTranslate(d2, 25.0);
            }
            d += ftileGeometry.getWidth() + 20.0;
        }
        throw new IllegalArgumentException();
    }

    private UTranslate getTranslate1(Ftile ftile, StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        double d = 0.0;
        for (Ftile ftile2 : this.tiles) {
            FtileGeometry ftileGeometry = this.dimDiamondAndTile(stringBounder, ftile2);
            if (ftile2 == ftile) {
                FtileGeometry ftileGeometry2 = ftile2.calculateDimension(stringBounder);
                double d2 = this.getAllDiamondsHeight(stringBounder);
                double d3 = (dimension2D.getHeight() - 2.0 * d2 - ((Dimension2D)ftileGeometry2).getHeight()) / 2.0 + d2;
                return new UTranslate(d + (((Dimension2D)ftileGeometry).getWidth() - ((Dimension2D)ftileGeometry2).getWidth()) / 2.0, d3);
            }
            d += ((Dimension2D)ftileGeometry).getWidth() + 20.0;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        for (Ftile ftile : this.tiles) {
            uGraphic.apply(this.getTranslate1(ftile, stringBounder)).draw(ftile);
        }
        for (Ftile ftile : this.diamonds) {
            uGraphic.apply(this.getTranslateDiamond1(ftile, stringBounder)).draw(ftile);
        }
        uGraphic.apply(this.getTranslate2(stringBounder)).draw(this.tile2);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>(this.tiles);
        arrayList.add(this.tile2);
        for (Ftile ftile : arrayList) {
            if (!ftile.calculateDimension(stringBounder).hasPointOut()) continue;
            return new FtileGeometry(dimension2D, dimension2D.getWidth() / 2.0, 0.0, dimension2D.getHeight());
        }
        return new FtileGeometry(dimension2D, dimension2D.getWidth() / 2.0, 0.0);
    }

    private FtileGeometry dimDiamondAndTile(StringBounder stringBounder, Ftile ftile) {
        for (int i = 0; i < this.tiles.size(); ++i) {
            Ftile ftile2 = this.tiles.get(i);
            Ftile ftile3 = this.diamonds.get(i);
            if (ftile2 != ftile && ftile3 != ftile) continue;
            FtileGeometry ftileGeometry = ftile2.calculateDimension(stringBounder);
            FtileGeometry ftileGeometry2 = ftile3.calculateDimension(stringBounder);
            return ftileGeometry2.appendBottom(ftileGeometry);
        }
        throw new UnsupportedOperationException();
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Object object;
        Dimension2D dimension2D = new Dimension2DDouble(0.0, 0.0);
        Dimension2D dimension2D2 = new Dimension2DDouble(0.0, 0.0);
        Dimension2D dimension2D3 = new Dimension2DDouble(0.0, 0.0);
        for (int i = 0; i < this.tiles.size(); ++i) {
            object = this.tiles.get(i);
            Ftile ftile = this.diamonds.get(i);
            FtileGeometry ftileGeometry = object.calculateDimension(stringBounder);
            FtileGeometry ftileGeometry2 = ftile.calculateDimension(stringBounder);
            FtileGeometry ftileGeometry3 = ftileGeometry2.appendBottom(ftileGeometry);
            dimension2D = Dimension2DDouble.mergeLR(dimension2D, ftileGeometry);
            dimension2D2 = Dimension2DDouble.mergeLR(dimension2D2, ftileGeometry2);
            dimension2D3 = Dimension2DDouble.mergeLR(dimension2D3, ftileGeometry3);
        }
        FtileGeometry ftileGeometry = this.tile2.calculateDimension(stringBounder);
        dimension2D = Dimension2DDouble.mergeLR(dimension2D, ftileGeometry);
        dimension2D3 = Dimension2DDouble.mergeLR(dimension2D3, ftileGeometry);
        object = new Dimension2DDouble(dimension2D3.getWidth(), ((Dimension2D)dimension2D2).getHeight() * 4.0 + dimension2D.getHeight());
        return Dimension2DDouble.delta((Dimension2D)object, 20.0 * (double)this.tiles.size(), 40.0);
    }

    private double getAllDiamondsHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = new Dimension2DDouble(0.0, 0.0);
        for (Ftile ftile : this.diamonds) {
            FtileGeometry ftileGeometry = ftile.calculateDimension(stringBounder);
            dimension2D = Dimension2DDouble.mergeLR(dimension2D, ftileGeometry);
        }
        return ((Dimension2D)dimension2D).getHeight();
    }

    class ConnectionHline
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionHline(HtmlColor htmlColor) {
            super(null, null);
            this.arrowColor = htmlColor;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Dimension2D dimension2D = FtileIfLong.this.calculateDimensionInternal(stringBounder);
            ArrayList<Ftile> arrayList = new ArrayList<Ftile>(FtileIfLong.this.tiles);
            arrayList.add(FtileIfLong.this.tile2);
            double d = dimension2D.getWidth() / 2.0;
            double d2 = dimension2D.getWidth() / 2.0;
            for (Ftile ftile : arrayList) {
                if (!ftile.calculateDimension(stringBounder).hasPointOut()) continue;
                UTranslate uTranslate = FtileIfLong.this.getTranslateFor(ftile, stringBounder);
                double d3 = ftile.calculateDimension(stringBounder).translate(uTranslate).getLeft();
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
            Snake snake = new Snake(this.arrowColor);
            snake.goUnmergeable();
            double d4 = dimension2D.getHeight();
            snake.addPoint(d, d4);
            snake.addPoint(d2, d4);
            uGraphic.draw(snake);
        }
    }

    class ConnectionVerticalOut
    extends AbstractConnection {
        private final HtmlColor color;

        public ConnectionVerticalOut(Ftile ftile, HtmlColor htmlColor) {
            super(ftile, null);
            this.color = htmlColor;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            double d = FtileIfLong.this.calculateDimensionInternal(stringBounder).getHeight();
            Point2D point2D = this.getP1(stringBounder);
            if (point2D == null) {
                return;
            }
            Point2D.Double double_ = new Point2D.Double(point2D.getX(), d);
            Snake snake = new Snake(this.color, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(double_);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return null;
            }
            Point2D point2D = ftileGeometry.getPointOut();
            return FtileIfLong.this.getTranslate1(this.getFtile1(), stringBounder).getTranslated(point2D);
        }
    }

    class ConnectionVerticalIn
    extends AbstractConnection {
        private final HtmlColor color;

        public ConnectionVerticalIn(Ftile ftile, Ftile ftile2, HtmlColor htmlColor) {
            super(ftile, ftile2);
            this.color = htmlColor;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.color, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            Point2D point2D = this.getFtile1().calculateDimension(stringBounder).getPointOut();
            return FtileIfLong.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(point2D);
        }

        private Point2D getP2(StringBounder stringBounder) {
            Point2D point2D = this.getFtile2().calculateDimension(stringBounder).getPointIn();
            return FtileIfLong.this.getTranslate1(this.getFtile2(), stringBounder).getTranslated(point2D);
        }
    }

    class ConnectionLastElseOut
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionLastElseOut(HtmlColor htmlColor) {
            super(FtileIfLong.this.tile2, null);
            this.arrowColor = htmlColor;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            UTranslate uTranslate = FtileIfLong.this.getTranslate2(stringBounder);
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Point2D point2D = uTranslate.getTranslated(ftileGeometry.getPointOut());
            double d = FtileIfLong.this.calculateDimensionInternal(stringBounder).getHeight();
            Point2D.Double double_ = new Point2D.Double(point2D.getX(), d);
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(double_);
            uGraphic.draw(snake);
        }
    }

    class ConnectionLastElseIn
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionLastElseIn(HtmlColor htmlColor) {
            super((Ftile)FtileIfLong.this.diamonds.get(FtileIfLong.this.diamonds.size() - 1), FtileIfLong.this.tile2);
            this.arrowColor = htmlColor;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            Point2D point2D = this.getP1(uGraphic.getStringBounder());
            UTranslate uTranslate = FtileIfLong.this.getTranslate2(uGraphic.getStringBounder());
            Point2D point2D2 = uTranslate.getTranslated(this.getFtile2().calculateDimension(uGraphic.getStringBounder()).getPointIn());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(point2D);
            snake.addPoint(point2D2.getX(), point2D.getY());
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            Point2D.Double double_ = new Point2D.Double(ftileGeometry.getWidth(), ftileGeometry.getOutY() / 2.0);
            return FtileIfLong.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(double_);
        }
    }

    class ConnectionIn
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionIn(HtmlColor htmlColor) {
            super(null, (Ftile)FtileIfLong.this.diamonds.get(0));
            this.arrowColor = htmlColor;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            UTranslate uTranslate = FtileIfLong.this.getTranslateDiamond1(this.getFtile2(), uGraphic.getStringBounder());
            Point2D point2D = uTranslate.getTranslated(this.getFtile2().calculateDimension(uGraphic.getStringBounder()).getPointIn());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            Point2D point2D2 = FtileIfLong.this.calculateDimension(uGraphic.getStringBounder()).getPointIn();
            snake.addPoint(point2D2);
            snake.addPoint(point2D.getX(), point2D2.getY());
            snake.addPoint(point2D);
            uGraphic.draw(snake);
        }
    }

    class ConnectionHorizontal
    extends AbstractConnection {
        private final HtmlColor color;

        public ConnectionHorizontal(Ftile ftile, Ftile ftile2, HtmlColor htmlColor) {
            super(ftile, ftile2);
            this.color = htmlColor;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.color, Arrows.asToRight());
            snake.addPoint(point2D);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            Point2D.Double double_ = new Point2D.Double(ftileGeometry.getWidth(), ftileGeometry.getOutY() / 2.0);
            return FtileIfLong.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(double_);
        }

        private Point2D getP2(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile2().calculateDimension(stringBounder);
            Point2D.Double double_ = new Point2D.Double(0.0, ftileGeometry.getOutY() / 2.0);
            return FtileIfLong.this.getTranslateDiamond1(this.getFtile2(), stringBounder).getTranslated(double_);
        }
    }
}

