/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondFoo1;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class FtileRepeat
extends AbstractFtile {
    private final Ftile repeat;
    private final Ftile diamond1;
    private final Ftile diamond2;
    private final TextBlock tbTest;

    private FtileRepeat(Ftile ftile, Ftile ftile2, Ftile ftile3, TextBlock textBlock) {
        super(ftile.shadowing());
        this.repeat = ftile;
        this.diamond1 = ftile2;
        this.diamond2 = ftile3;
        this.tbTest = textBlock;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.repeat.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.repeat.getSwimlanes();
    }

    public static Ftile create(LinkRendering linkRendering, Swimlane swimlane, Ftile ftile, Display display, Display display2, Display display3, HtmlColor htmlColor, HtmlColor htmlColor2, UFont uFont, HtmlColor htmlColor3, HtmlColor htmlColor4, ConditionStyle conditionStyle, ISkinSimple iSkinSimple, HtmlColor htmlColor5, boolean bl) {
        FtileRepeat ftileRepeat;
        Object object;
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK, htmlColor5, bl);
        TextBlock textBlock = TextBlockUtils.create(display, fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple);
        TextBlock textBlock2 = TextBlockUtils.create(display2, fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple);
        TextBlock textBlock3 = TextBlockUtils.create(display3, fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple);
        FtileDiamond ftileDiamond = new FtileDiamond(ftile.shadowing(), htmlColor2, htmlColor, swimlane);
        if (conditionStyle == ConditionStyle.INSIDE) {
            object = new FtileDiamondInside(ftile.shadowing(), htmlColor2, htmlColor, swimlane, textBlock).withEast(textBlock2).withSouth(textBlock3);
            ftileRepeat = new FtileRepeat(ftile, ftileDiamond, (Ftile)object, TextBlockUtils.empty(0.0, 0.0));
        } else if (conditionStyle == ConditionStyle.DIAMOND) {
            object = new FtileDiamond(ftile.shadowing(), htmlColor2, htmlColor, swimlane).withEast(textBlock);
            ftileRepeat = new FtileRepeat(ftile, ftileDiamond, (Ftile)object, textBlock);
        } else if (conditionStyle == ConditionStyle.FOO1) {
            object = new FtileDiamondFoo1(ftile.shadowing(), htmlColor2, htmlColor, swimlane, textBlock);
            ftileRepeat = new FtileRepeat(ftile, ftileDiamond, (Ftile)object, TextBlockUtils.empty(0.0, 0.0));
        } else {
            throw new IllegalStateException();
        }
        object = new ArrayList();
        Display display4 = LinkRendering.getDisplay(ftile.getInLinkRendering());
        TextBlock textBlock4 = display4 == null ? null : TextBlockUtils.create(display4, fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple, true);
        FtileRepeat ftileRepeat2 = ftileRepeat;
        ftileRepeat2.getClass();
        object.add(ftileRepeat2.new ConnectionIn(LinkRendering.getColor(ftile.getInLinkRendering(), htmlColor3), textBlock4));
        Display display5 = LinkRendering.getDisplay(linkRendering);
        TextBlock textBlock5 = display5 == null ? null : TextBlockUtils.create(display5, fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple, true);
        FtileRepeat ftileRepeat3 = ftileRepeat;
        ftileRepeat3.getClass();
        object.add(ftileRepeat3.new ConnectionBack(LinkRendering.getColor(linkRendering, htmlColor3), textBlock5));
        Display display6 = LinkRendering.getDisplay(ftile.getOutLinkRendering());
        TextBlock textBlock6 = display6 == null ? null : TextBlockUtils.create(display6, fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple, true);
        FtileRepeat ftileRepeat4 = ftileRepeat;
        ftileRepeat4.getClass();
        object.add(ftileRepeat4.new ConnectionOut(LinkRendering.getColor(htmlColor4, htmlColor3), textBlock6));
        return FtileUtils.addConnection((Ftile)ftileRepeat, (Collection<Connection>)object);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.apply(this.getTranslateForRepeat(stringBounder)).draw(this.repeat);
        uGraphic.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        uGraphic.apply(this.getTranslateDiamond2(stringBounder)).draw(this.diamond2);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        return new FtileGeometry(dimension2D, this.getLeft(stringBounder), 0.0, dimension2D.getHeight());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond2.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry3 = this.repeat.calculateDimension(stringBounder);
        double d = this.tbTest.calculateDimension(stringBounder).getWidth();
        double d2 = this.getLeft(stringBounder) + this.getRight(stringBounder);
        d2 = Math.max(d2, d + 24.0);
        double d3 = ((Dimension2D)ftileGeometry).getHeight() + ((Dimension2D)ftileGeometry3).getHeight() + ((Dimension2D)ftileGeometry2).getHeight() + 96.0;
        return new Dimension2DDouble(d2 + 24.0, d3);
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.repeat) {
            return this.getTranslateForRepeat(stringBounder);
        }
        if (ftile == this.diamond1) {
            return this.getTranslateDiamond1(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslateForRepeat(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond2.calculateDimension(stringBounder);
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry3 = this.repeat.calculateDimension(stringBounder);
        double d = (dimension2D.getHeight() - ((Dimension2D)ftileGeometry).getHeight() - ((Dimension2D)ftileGeometry2).getHeight() - ((Dimension2D)ftileGeometry3).getHeight()) / 2.0;
        double d2 = this.getLeft(stringBounder);
        return new UTranslate(d2 - this.repeat.calculateDimension(stringBounder).getLeft(), d);
    }

    private UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        double d = this.getLeft(stringBounder);
        return new UTranslate(d - ((Dimension2D)ftileGeometry).getWidth() / 2.0, 0.0);
    }

    private UTranslate getTranslateDiamond2(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry = this.diamond2.calculateDimension(stringBounder);
        double d = dimension2D.getHeight() - ((Dimension2D)ftileGeometry).getHeight();
        double d2 = this.getLeft(stringBounder);
        return new UTranslate(d2 - ((Dimension2D)ftileGeometry).getWidth() / 2.0, d);
    }

    private double getLeft(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond2.calculateDimension(stringBounder);
        double d = this.repeat.calculateDimension(stringBounder).getLeft();
        d = Math.max(d, ((Dimension2D)ftileGeometry).getWidth() / 2.0);
        double d2 = this.repeat.calculateDimension(stringBounder).getLeft();
        d2 = Math.max(d2, ((Dimension2D)ftileGeometry2).getWidth() / 2.0);
        return Math.max(d, d2);
    }

    private double getRight(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond2.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry3 = this.repeat.calculateDimension(stringBounder);
        double d = ((Dimension2D)ftileGeometry3).getWidth() - this.repeat.calculateDimension(stringBounder).getLeft();
        d = Math.max(d, ((Dimension2D)ftileGeometry).getWidth() / 2.0);
        double d2 = ((Dimension2D)ftileGeometry3).getWidth() - this.repeat.calculateDimension(stringBounder).getLeft();
        d2 = Math.max(d2, ((Dimension2D)ftileGeometry2).getWidth() / 2.0);
        return Math.max(d, d2);
    }

    class ConnectionBack
    extends AbstractConnection {
        private final HtmlColor arrowColor;
        private final TextBlock tbback;

        public ConnectionBack(HtmlColor htmlColor, TextBlock textBlock) {
            super(FtileRepeat.this.diamond2, FtileRepeat.this.repeat);
            this.arrowColor = htmlColor;
            this.tbback = textBlock;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond2(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowColor, Arrows.asToLeft());
            snake.setLabel(this.tbback);
            snake.emphasizeDirection(Direction.UP);
            Dimension2D dimension2D = FtileRepeat.this.calculateDimensionInternal(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            FtileGeometry ftileGeometry = FtileRepeat.this.diamond1.calculateDimension(stringBounder);
            FtileGeometry ftileGeometry2 = FtileRepeat.this.diamond2.calculateDimension(stringBounder);
            double d = point2D.getX() + ((Dimension2D)ftileGeometry2).getWidth();
            double d2 = point2D.getY() + ((Dimension2D)ftileGeometry2).getHeight() / 2.0;
            double d3 = point2D2.getX() + ((Dimension2D)ftileGeometry).getWidth();
            double d4 = point2D2.getY() + ((Dimension2D)ftileGeometry).getHeight() / 2.0;
            snake.addPoint(d, d2);
            double d5 = dimension2D.getWidth() - 12.0;
            snake.addPoint(d5, d2);
            snake.addPoint(d5, d4);
            snake.addPoint(d3, d4);
            uGraphic.draw(snake);
        }
    }

    class ConnectionOut
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final HtmlColor arrowColor;
        private final TextBlock tbout;

        public ConnectionOut(HtmlColor htmlColor, TextBlock textBlock) {
            super(FtileRepeat.this.repeat, FtileRepeat.this.diamond2);
            this.arrowColor = htmlColor;
            this.tbout = textBlock;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateForRepeat(stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond2(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.setLabel(this.tbout);
            snake.addPoint(this.getP1(stringBounder));
            snake.addPoint(this.getP2(stringBounder));
            uGraphic.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowColor);
            snake.setLabel(this.tbout);
            Point2D point2D = uTranslate.getTranslated(this.getP1(stringBounder));
            Point2D point2D2 = uTranslate2.getTranslated(this.getP2(stringBounder));
            double d = (point2D.getY() + point2D2.getY()) / 2.0;
            snake.addPoint(point2D);
            snake.addPoint(point2D.getX(), d);
            snake.addPoint(point2D2.getX(), d);
            uGraphic.draw(snake);
            Snake snake2 = new Snake(this.arrowColor, Arrows.asToDown());
            snake2.addPoint(point2D2.getX(), d);
            snake2.addPoint(point2D2);
            uGraphic.draw(snake2);
        }
    }

    class ConnectionIn
    extends AbstractConnection {
        private final HtmlColor arrowColor;
        private final TextBlock tbin;

        public ConnectionIn(HtmlColor htmlColor, TextBlock textBlock) {
            super(FtileRepeat.this.diamond1, FtileRepeat.this.repeat);
            this.arrowColor = htmlColor;
            this.tbin = textBlock;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return this.getFtile1().calculateDimension(stringBounder).translate(FtileRepeat.this.getTranslateDiamond1(stringBounder)).getPointOut();
        }

        private Point2D getP2(StringBounder stringBounder) {
            return this.getFtile2().calculateDimension(stringBounder).translate(FtileRepeat.this.getTranslateForRepeat(stringBounder)).getPointIn();
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.setLabel(this.tbin);
            snake.addPoint(this.getP1(stringBounder));
            snake.addPoint(this.getP2(stringBounder));
            uGraphic.draw(snake);
        }
    }
}

