/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextGroupingElse
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextGroupingElse(ComponentType componentType, Display display, FileFormat fileFormat) {
        this.type = componentType;
        this.stringsToDisplay = display;
        this.fileFormat = fileFormat;
    }

    @Override
    public void drawU(UGraphic uGraphic, Area area, Context2D context2D) {
        Dimension2D dimension2D = area.getDimensionToUse();
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth();
        if (this.stringsToDisplay.get(0) != null) {
            umlCharArea.drawStringLR("[" + this.stringsToDisplay.get(0) + "]", 2, 0);
        }
        if (this.fileFormat == FileFormat.UTXT) {
            umlCharArea.drawChar('\u2560', 0, -1);
            umlCharArea.drawChar('\u2563', n - 1, -1);
            umlCharArea.drawHLine('\u2550', -1, 1, n - 1, '\u2502', '\u256a');
        } else {
            umlCharArea.drawHLine('~', -1, 1, n - 1);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return 1.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return 1.0;
    }
}

