/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextGroupingHeader
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextGroupingHeader(ComponentType componentType, Display display, FileFormat fileFormat) {
        this.type = componentType;
        this.stringsToDisplay = display;
        this.fileFormat = fileFormat;
    }

    @Override
    public void drawU(UGraphic uGraphic, Area area, Context2D context2D) {
        Dimension2D dimension2D = area.getDimensionToUse();
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        String string = this.stringsToDisplay.get(0).toString();
        if (this.fileFormat == FileFormat.UTXT) {
            umlCharArea.drawHLine('\u2550', 0, 1, n - 1, '\u2502', '\u256a');
            umlCharArea.drawStringLR(StringUtils.goUpperCase(string) + "  /", 2, 1);
            umlCharArea.drawHLine('\u2500', 2, 1, string.length() + 4);
            umlCharArea.drawVLine('\u2551', 0, 1, n2 - 1);
            umlCharArea.drawVLine('\u2551', n - 1, 1, n2 - 1);
            umlCharArea.drawChar('\u255f', 0, 2);
            umlCharArea.drawStringTB("\u2564\u2502\u2518", string.length() + 4, 0);
            umlCharArea.drawChar('\u2554', 0, 0);
            umlCharArea.drawChar('\u2557', n - 1, 0);
            umlCharArea.drawHLine('\u2550', n2 - 1, 1, n - 1, '\u2502', '\u256a');
            umlCharArea.drawChar('\u255a', 0, n2 - 1);
            umlCharArea.drawChar('\u255d', n - 1, n2 - 1);
        } else {
            umlCharArea.drawHLine('_', 0, 0, n - 1);
            umlCharArea.drawStringLR(StringUtils.goUpperCase(string) + "  /", 2, 1);
            umlCharArea.drawHLine('_', 2, 1, string.length() + 3);
            umlCharArea.drawChar('/', string.length() + 3, 2);
            umlCharArea.drawVLine('!', 0, 1, n2);
            umlCharArea.drawVLine('!', n - 1, 1, n2);
            umlCharArea.drawHLine('~', n2 - 1, 1, n - 1);
        }
        if (this.stringsToDisplay.size() > 1) {
            String string2 = this.stringsToDisplay.get(1).toString();
            umlCharArea.drawStringLR(string2, string.length() + 7, 1);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 1;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWidth(this.stringsToDisplay) + 2;
    }
}

