/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextSelfArrow
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;
    private final ArrowConfiguration config;

    public ComponentTextSelfArrow(ComponentType componentType, ArrowConfiguration arrowConfiguration, Display display, FileFormat fileFormat) {
        this.type = componentType;
        this.stringsToDisplay = display;
        this.fileFormat = fileFormat;
        this.config = arrowConfiguration;
    }

    @Override
    public void drawU(UGraphic uGraphic, Area area, Context2D context2D) {
        Dimension2D dimension2D = area.getDimensionToUse();
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight() - 1;
        umlCharArea.fillRect(' ', 0, 0, n, n2);
        if (this.fileFormat == FileFormat.UTXT) {
            if (this.config.isDotted()) {
                umlCharArea.drawStringLR("\u2500 \u2500 \u2510", 0, 0);
                umlCharArea.drawStringLR("|", 4, 1);
                umlCharArea.drawStringLR("< \u2500 \u2518", 0, 2);
            } else {
                umlCharArea.drawStringLR("\u2500\u2500\u2500\u2500\u2510", 0, 0);
                umlCharArea.drawStringLR("\u2502", 4, 1);
                umlCharArea.drawStringLR("<\u2500\u2500\u2500\u2518", 0, 2);
            }
        } else if (this.config.isDotted()) {
            umlCharArea.drawStringLR("- - .", 0, 0);
            umlCharArea.drawStringLR("|", 4, 1);
            umlCharArea.drawStringLR("< - '", 0, 2);
        } else {
            umlCharArea.drawStringLR("----.", 0, 0);
            umlCharArea.drawStringLR("|", 4, 1);
            umlCharArea.drawStringLR("<---'", 0, 2);
        }
        umlCharArea.drawStringsLR(this.stringsToDisplay.as(), 6, 1);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 3;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWidth(this.stringsToDisplay) + 6;
    }
}

