/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandAddMethod;
import net.sourceforge.plantuml.classdiagram.command.CommandAllowMixing;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClass;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateElementFull2;
import net.sourceforge.plantuml.classdiagram.command.CommandDiamondAssociation;
import net.sourceforge.plantuml.classdiagram.command.CommandHideShowSpecificClass;
import net.sourceforge.plantuml.classdiagram.command.CommandImport;
import net.sourceforge.plantuml.classdiagram.command.CommandLayoutNewLine;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkLollipop;
import net.sourceforge.plantuml.classdiagram.command.CommandMouseOver;
import net.sourceforge.plantuml.classdiagram.command.CommandNamespaceSeparator;
import net.sourceforge.plantuml.classdiagram.command.CommandStereotype;
import net.sourceforge.plantuml.classdiagram.command.CommandUrl;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandEndPackage;
import net.sourceforge.plantuml.command.CommandFootboxIgnored;
import net.sourceforge.plantuml.command.CommandNamespace;
import net.sourceforge.plantuml.command.CommandPackage;
import net.sourceforge.plantuml.command.CommandPackageEmpty;
import net.sourceforge.plantuml.command.CommandPage;
import net.sourceforge.plantuml.command.CommandRankDir;
import net.sourceforge.plantuml.command.UmlDiagramFactory;
import net.sourceforge.plantuml.command.note.FactoryNoteCommand;
import net.sourceforge.plantuml.command.note.FactoryNoteOnEntityCommand;
import net.sourceforge.plantuml.command.note.FactoryNoteOnLinkCommand;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.cucadiagram.Link;

public class ClassDiagramFactory
extends UmlDiagramFactory {
    @Override
    public ClassDiagram createEmptyDiagram() {
        return new ClassDiagram();
    }

    @Override
    protected List<Command> createCommands() {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        arrayList.add(new CommandFootboxIgnored());
        this.addCommonCommands(arrayList);
        arrayList.add(new CommandRankDir());
        arrayList.add(new CommandPage());
        arrayList.add(new CommandAddMethod());
        arrayList.add(new CommandCreateClass());
        arrayList.add(new CommandAllowMixing());
        arrayList.add(new CommandLayoutNewLine());
        arrayList.add(new CommandCreateElementFull2(CommandCreateElementFull2.Mode.NORMAL_KEYWORD));
        arrayList.add(new CommandCreateElementFull2(CommandCreateElementFull2.Mode.WITH_MIX_PREFIX));
        FactoryNoteCommand factoryNoteCommand = new FactoryNoteCommand();
        arrayList.add(factoryNoteCommand.createSingleLine());
        arrayList.add(new CommandPackage());
        arrayList.add(new CommandEndPackage());
        arrayList.add(new CommandPackageEmpty());
        arrayList.add(new CommandNamespace());
        arrayList.add(new CommandStereotype());
        arrayList.add(new CommandLinkClass(UmlDiagramType.CLASS));
        arrayList.add(new CommandLinkLollipop(UmlDiagramType.CLASS));
        arrayList.add(new CommandImport());
        FactoryNoteOnEntityCommand factoryNoteOnEntityCommand = new FactoryNoteOnEntityCommand(new RegexLeaf("ENTITY", "([^%s{}%g<>]+|[%g][^%g]+[%g])"));
        arrayList.add(factoryNoteOnEntityCommand.createSingleLine());
        arrayList.add(new CommandUrl());
        arrayList.add(factoryNoteOnEntityCommand.createMultiLine());
        arrayList.add(factoryNoteCommand.createMultiLine());
        arrayList.add(new CommandCreateClassMultilines());
        FactoryNoteOnLinkCommand factoryNoteOnLinkCommand = new FactoryNoteOnLinkCommand();
        arrayList.add(factoryNoteOnLinkCommand.createSingleLine());
        arrayList.add(factoryNoteOnLinkCommand.createMultiLine());
        arrayList.add(new CommandDiamondAssociation());
        arrayList.add(new CommandMouseOver());
        arrayList.add(new CommandHideShowSpecificClass());
        arrayList.add(new CommandNamespaceSeparator());
        return arrayList;
    }

    @Override
    public String checkFinalError(AbstractPSystem abstractPSystem) {
        ClassDiagram classDiagram = (ClassDiagram)abstractPSystem;
        for (Link link : classDiagram.getLinks()) {
            int n = link.getLength();
            if (n != 1) continue;
            for (Link link2 : classDiagram.getLinks()) {
                if (!link2.sameConnections(link) || link2.getLength() == 1) continue;
                link2.setLength(1);
            }
        }
        classDiagram.applySingleStrategy();
        return super.checkFinalError(classDiagram);
    }
}

