/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.USymbol;

public class CommandCreateElementFull2
extends SingleLineCommand2<ClassDiagram> {
    private final Mode mode;
    private static final String CODE_CORE = "[\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]";
    private static final String CODE = "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])";
    private static final String CODE_WITH_QUOTE = "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|[%g][^%g]+[%g])";
    private static final String DISPLAY_CORE = "[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]";
    private static final String DISPLAY = "([%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])";
    private static final String DISPLAY_WITHOUT_QUOTE = "([%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|[\\p{L}0-9_.]+)";

    public CommandCreateElementFull2(Mode mode) {
        super(CommandCreateElementFull2.getRegexConcat(mode));
        this.mode = mode;
    }

    private static RegexConcat getRegexConcat(Mode mode) {
        String string = "(?:(actor|usecase|component)[%s]+)";
        if (mode == Mode.WITH_MIX_PREFIX) {
            string = "mix_" + string;
        }
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("SYMBOL", string), new RegexLeaf("[%s]*"), new RegexOr(new RegexLeaf("CODE1", CODE_WITH_QUOTE)), new RegexLeaf("STEREOTYPE", "(?:[%s]*(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("$"));
    }

    @Override
    protected final boolean isForbidden(String string) {
        return string.matches("^[\\p{L}0-9_.]+$");
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram classDiagram, RegexResult regexResult) {
        String string;
        USymbol uSymbol;
        LeafType leafType;
        String string2;
        if (this.mode == Mode.NORMAL_KEYWORD && !classDiagram.isAllowMixing()) {
            return CommandExecutionResult.error("Use 'allow_mixing' if you want to mix classes and other UML elements.");
        }
        String string3 = regexResult.getLazzy("CODE", 0);
        String string4 = regexResult.getLazzy("DISPLAY", 0);
        char c = this.getCharEncoding(string3);
        char c2 = this.getCharEncoding(string4);
        if (string3.startsWith("()")) {
            string2 = "interface";
            string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string3.substring(2).trim());
        } else {
            string2 = c == '(' || c2 == '(' ? "usecase" : (c == ':' || c2 == ':' ? "actor" : (c == '[' || c2 == '[' ? "component" : regexResult.get("SYMBOL", 0)));
        }
        if (string2 == null) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.ACTOR;
        } else if (string2.equalsIgnoreCase("artifact")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.ARTIFACT;
        } else if (string2.equalsIgnoreCase("folder")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.FOLDER;
        } else if (string2.equalsIgnoreCase("package")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.PACKAGE;
        } else if (string2.equalsIgnoreCase("rectangle")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.RECTANGLE;
        } else if (string2.equalsIgnoreCase("node")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.NODE;
        } else if (string2.equalsIgnoreCase("frame")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.FRAME;
        } else if (string2.equalsIgnoreCase("cloud")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.CLOUD;
        } else if (string2.equalsIgnoreCase("database")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.DATABASE;
        } else if (string2.equalsIgnoreCase("storage")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.STORAGE;
        } else if (string2.equalsIgnoreCase("agent")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.AGENT;
        } else if (string2.equalsIgnoreCase("actor")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.ACTOR;
        } else if (string2.equalsIgnoreCase("component")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = classDiagram.getSkinParam().useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1;
        } else if (string2.equalsIgnoreCase("boundary")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.BOUNDARY;
        } else if (string2.equalsIgnoreCase("control")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.CONTROL;
        } else if (string2.equalsIgnoreCase("entity")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.ENTITY_DOMAIN;
        } else if (string2.equalsIgnoreCase("interface")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.INTERFACE;
        } else if (string2.equalsIgnoreCase("()")) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.INTERFACE;
        } else if (string2.equalsIgnoreCase("usecase")) {
            leafType = LeafType.USECASE;
            uSymbol = null;
        } else {
            throw new IllegalStateException();
        }
        Code code = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string3));
        String string5 = string4;
        if (string5 == null) {
            string5 = code.getFullName();
        }
        string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string5);
        String string6 = regexResult.getLazzy("STEREOTYPE", 0);
        ILeaf iLeaf = classDiagram.getOrCreateLeaf(code, leafType, uSymbol);
        iLeaf.setDisplay(Display.getWithNewlines(string5));
        iLeaf.setUSymbol(uSymbol);
        if (string6 != null) {
            iLeaf.setStereotype(new Stereotype(string6, classDiagram.getSkinParam().getCircledCharacterRadius(), classDiagram.getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null, false), classDiagram.getSkinParam().getIHtmlColorSet()));
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(classDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(string);
            iLeaf.addUrl(url);
        }
        iLeaf.setSpecificBackcolor(classDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0)));
        return CommandExecutionResult.ok();
    }

    private char getCharEncoding(String string) {
        return string != null && string.length() > 2 ? string.charAt(0) : (char)'\u0000';
    }

    public static enum Mode {
        NORMAL_KEYWORD,
        WITH_MIX_PREFIX;

    }
}

