/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.EnumSet;
import java.util.Set;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.EntityGender;
import net.sourceforge.plantuml.cucadiagram.EntityGenderUtils;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;

public class CommandHideShow
extends SingleLineCommand2<UmlDiagram> {
    private static final EnumSet<EntityPortion> PORTION_METHOD = EnumSet.of(EntityPortion.METHOD);
    private static final EnumSet<EntityPortion> PORTION_MEMBER = EnumSet.of(EntityPortion.FIELD, EntityPortion.METHOD);
    private static final EnumSet<EntityPortion> PORTION_FIELD = EnumSet.of(EntityPortion.FIELD);

    public CommandHideShow() {
        super(CommandHideShow.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("COMMAND", "(hide|show)"), new RegexLeaf("[%s]+"), new RegexLeaf("GENDER", "(?:(class|interface|enum|annotation|abstract|[\\p{L}0-9_.]+|[%g][^%g]+[%g]|\\<\\<.*\\>\\>)[%s]+)*?"), new RegexLeaf("EMPTY", "(?:(empty)[%s]+)?"), new RegexLeaf("PORTION", "(members?|attributes?|fields?|methods?|circle\\w*|stereotypes?)"), new RegexLeaf("$"));
    }

    private final EntityGender emptyByGender(Set<EntityPortion> set) {
        if (set == PORTION_METHOD) {
            return EntityGenderUtils.emptyMethods();
        }
        if (set == PORTION_FIELD) {
            return EntityGenderUtils.emptyFields();
        }
        if (set == PORTION_MEMBER) {
            return EntityGenderUtils.emptyMembers();
        }
        return EntityGenderUtils.all();
    }

    @Override
    protected CommandExecutionResult executeArg(UmlDiagram umlDiagram, RegexResult regexResult) {
        if (umlDiagram instanceof ClassDiagram) {
            return this.executeClassDiagram((ClassDiagram)umlDiagram, regexResult);
        }
        if (umlDiagram instanceof DescriptionDiagram) {
            return this.executeDescriptionDiagram((DescriptionDiagram)umlDiagram, regexResult);
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeDescriptionDiagram(DescriptionDiagram descriptionDiagram, RegexResult regexResult) {
        EntityGender entityGender;
        Set<EntityPortion> set = this.getEntityPortion(regexResult.get("PORTION", 0));
        String string = regexResult.get("GENDER", 0);
        if (string == null) {
            entityGender = EntityGenderUtils.all();
        } else if (string.equalsIgnoreCase("class")) {
            entityGender = EntityGenderUtils.byEntityType(LeafType.CLASS);
        } else if (string.equalsIgnoreCase("interface")) {
            entityGender = EntityGenderUtils.byEntityType(LeafType.INTERFACE);
        } else if (string.equalsIgnoreCase("enum")) {
            entityGender = EntityGenderUtils.byEntityType(LeafType.ENUM);
        } else if (string.equalsIgnoreCase("abstract")) {
            entityGender = EntityGenderUtils.byEntityType(LeafType.ABSTRACT_CLASS);
        } else if (string.equalsIgnoreCase("annotation")) {
            entityGender = EntityGenderUtils.byEntityType(LeafType.ANNOTATION);
        } else if (string.startsWith("<<")) {
            entityGender = EntityGenderUtils.byStereotype(string);
        } else {
            ILeaf iLeaf = descriptionDiagram.getOrCreateLeaf(Code.of(string), null, null);
            entityGender = EntityGenderUtils.byEntityAlone(iLeaf);
        }
        descriptionDiagram.hideOrShow(entityGender, set, regexResult.get("COMMAND", 0).equalsIgnoreCase("show"));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeClassDiagram(ClassDiagram classDiagram, RegexResult regexResult) {
        Set<EntityPortion> set = this.getEntityPortion(regexResult.get("PORTION", 0));
        EntityGender entityGender = null;
        String string = regexResult.get("GENDER", 0);
        if (string == null) {
            entityGender = EntityGenderUtils.all();
        } else if (string.equalsIgnoreCase("class")) {
            entityGender = EntityGenderUtils.byEntityType(LeafType.CLASS);
        } else if (string.equalsIgnoreCase("interface")) {
            entityGender = EntityGenderUtils.byEntityType(LeafType.INTERFACE);
        } else if (string.equalsIgnoreCase("enum")) {
            entityGender = EntityGenderUtils.byEntityType(LeafType.ENUM);
        } else if (string.equalsIgnoreCase("abstract")) {
            entityGender = EntityGenderUtils.byEntityType(LeafType.ABSTRACT_CLASS);
        } else if (string.equalsIgnoreCase("annotation")) {
            entityGender = EntityGenderUtils.byEntityType(LeafType.ANNOTATION);
        } else if (string.startsWith("<<")) {
            entityGender = EntityGenderUtils.byStereotype(string);
        } else {
            ILeaf iLeaf = classDiagram.getOrCreateLeaf(Code.of(string), null, null);
            entityGender = EntityGenderUtils.byEntityAlone(iLeaf);
        }
        if (entityGender != null) {
            boolean bl;
            boolean bl2 = bl = regexResult.get("EMPTY", 0) != null;
            if (bl) {
                entityGender = EntityGenderUtils.and(entityGender, this.emptyByGender(set));
            }
            if (!EntityUtils.groupRoot(classDiagram.getCurrentGroup())) {
                entityGender = EntityGenderUtils.and(entityGender, EntityGenderUtils.byPackage(classDiagram.getCurrentGroup()));
            }
            classDiagram.hideOrShow(entityGender, set, regexResult.get("COMMAND", 0).equalsIgnoreCase("show"));
        }
        return CommandExecutionResult.ok();
    }

    private Set<EntityPortion> getEntityPortion(String string) {
        String string2 = StringUtils.goLowerCase(string.substring(0, 3));
        if (string2.equals("met")) {
            return PORTION_METHOD;
        }
        if (string2.equals("mem")) {
            return PORTION_MEMBER;
        }
        if (string2.equals("att") || string2.equals("fie")) {
            return PORTION_FIELD;
        }
        if (string2.equals("cir")) {
            return EnumSet.of(EntityPortion.CIRCLED_CHARACTER);
        }
        if (string2.equals("ste")) {
            return EnumSet.of(EntityPortion.STEREOTYPE);
        }
        throw new IllegalArgumentException();
    }
}

