/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;

public class CommandHideShowSpecificClass
extends SingleLineCommand2<ClassDiagram> {
    public CommandHideShowSpecificClass() {
        super(CommandHideShowSpecificClass.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("COMMAND", "(hide|show)"), new RegexLeaf("[%s]+"), new RegexLeaf("CODE", "([^%s{}%g<>]+)"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram classDiagram, RegexResult regexResult) {
        String string = regexResult.get("CODE", 0);
        if (string.equals("class")) {
            classDiagram.hideOrShow(LeafType.CLASS, regexResult.get("COMMAND", 0).equalsIgnoreCase("show"));
        } else if (string.equals("interface")) {
            classDiagram.hideOrShow(LeafType.INTERFACE, regexResult.get("COMMAND", 0).equalsIgnoreCase("show"));
        } else {
            Code code = Code.of(string);
            ILeaf iLeaf = classDiagram.getEntityFactory().getLeafs().get(code);
            if (iLeaf == null) {
                return CommandExecutionResult.error("Class does not exist : " + code.getFullName());
            }
            classDiagram.hideOrShow(iLeaf, regexResult.get("COMMAND", 0).equalsIgnoreCase("show"));
        }
        return CommandExecutionResult.ok();
    }
}

