/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.ILeaf;

public class CommandMouseOver
extends CommandMultilines2<ClassDiagram> {
    public CommandMouseOver() {
        super(CommandMouseOver.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^[%s]*\\}[%s]*$";
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("mouseover[%s]+"), new RegexOr(new RegexLeaf("NAME1", "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)"), new RegexLeaf("NAME3", "[%g]([^%g]+)[%g]")), new RegexLeaf("[%s]*\\{[%s]*$"));
    }

    @Override
    public CommandExecutionResult executeNow(ClassDiagram classDiagram, List<String> list) {
        StringUtils.trim(list, false);
        RegexResult regexResult = this.getStartingPattern().matcher(list.get(0).trim());
        Code code = Code.of(regexResult.get("NAME1", 0));
        if (code == null) {
            code = Code.of(regexResult.get("NAME3", 0));
        }
        if (!classDiagram.leafExist(code)) {
            return CommandExecutionResult.error("No such entity");
        }
        ILeaf iLeaf = classDiagram.getLeafsget(code);
        for (String string : list.subList(1, list.size() - 1)) {
            iLeaf.mouseOver(string);
        }
        return CommandExecutionResult.ok();
    }
}

