/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.IEntity;

public class CommandUrl
extends SingleLineCommand<AbstractEntityDiagram> {
    public CommandUrl() {
        super("(?i)^url[%s]*(?:of|for)?[%s]+([\\p{L}0-9_.]+|[%g][^%g]+[%g])[%s]+(?:is)?[%s]*(" + UrlBuilder.getRegexp() + ")$");
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram abstractEntityDiagram, List<String> list) {
        IEntity iEntity;
        Code code = Code.of(list.get(0));
        String string = list.get(1);
        if (abstractEntityDiagram.leafExist(code)) {
            iEntity = abstractEntityDiagram.getOrCreateLeaf(code, null, null);
        } else if (abstractEntityDiagram.isGroup(code)) {
            iEntity = abstractEntityDiagram.getGroup(code);
        } else {
            return CommandExecutionResult.error(code + " does not exist");
        }
        UrlBuilder urlBuilder = new UrlBuilder(abstractEntityDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
        Url url = urlBuilder.getUrl(string);
        iEntity.addUrl(url);
        return CommandExecutionResult.ok();
    }
}

