/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.code.StringCompressor;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;

public class ArobaseStringCompressor
implements StringCompressor {
    private static final Pattern p = MyPattern.cmpile("(?s)(?i)^[%s]*(@startuml[^\\n\\r]*)?[%s]*(.*?)[%s]*(@enduml)?[%s]*$");

    @Override
    public String compress(String string) throws IOException {
        UncommentReadLine uncommentReadLine = new UncommentReadLine(new ReadLineReader(new StringReader(string)));
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string2 = null;
        boolean bl = false;
        while ((string2 = uncommentReadLine.readLine()) != null) {
            this.append(stringBuilder2, string2);
            if (string2.startsWith("@startuml")) {
                bl = true;
                continue;
            }
            if (string2.startsWith("@enduml")) {
                return stringBuilder.toString();
            }
            if (!bl) continue;
            this.append(stringBuilder, string2);
        }
        if (!bl) {
            return this.compressOld(stringBuilder2.toString());
        }
        return stringBuilder.toString();
    }

    private void append(StringBuilder stringBuilder, String string) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append('\n');
        }
        stringBuilder.append(string);
    }

    private String compressOld(String string) throws IOException {
        Matcher matcher = p.matcher(string);
        if (matcher.find()) {
            return this.clean(matcher.group(2));
        }
        return "";
    }

    @Override
    public String decompress(String string) throws IOException {
        String string2 = this.clean(string);
        if (string2.startsWith("@start")) {
            return string2;
        }
        string2 = "@startuml\n" + string2;
        if (!string2.endsWith("\n")) {
            string2 = string2 + "\n";
        }
        string2 = string2 + "@enduml";
        return string2;
    }

    private String clean(String string) {
        string = string.trim();
        string = this.clean1(string);
        string = string.replaceAll("@enduml[^\\n\\r]*", "");
        string = string.replaceAll("@startuml[^\\n\\r]*", "");
        string = string.trim();
        return string;
    }

    private String clean1(String string) {
        Matcher matcher = p.matcher(string);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return string;
    }
}

