/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sourceforge.plantuml.code.Compression;

public class CompressionGZip
implements Compression {
    @Override
    public byte[] compress(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            MyGZIPOutputStream myGZIPOutputStream = new MyGZIPOutputStream(byteArrayOutputStream);
            myGZIPOutputStream.write(byArray);
            myGZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
    }

    @Override
    public byte[] decompress(byte[] byArray) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        while ((n = gZIPInputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        gZIPInputStream.close();
        byteArrayInputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    class MyGZIPOutputStream
    extends GZIPOutputStream {
        public MyGZIPOutputStream(OutputStream outputStream) throws IOException {
            super(outputStream);
            this.def.setLevel(9);
        }
    }
}

