/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.core.Diagram;

public abstract class CommandMultilines<S extends Diagram>
implements Command<S> {
    private final Pattern starting;

    public CommandMultilines(String string) {
        if (!string.startsWith("(?i)^") || !string.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + string);
        }
        this.starting = MyPattern.cmpile(string);
    }

    public abstract String getPatternEnd();

    @Override
    public String[] getDescription() {
        return new String[]{"START: " + this.starting.pattern(), "END: " + this.getPatternEnd()};
    }

    @Override
    public final CommandControl isValid(List<String> list) {
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        Matcher matcher = this.starting.matcher(list.get(0).trim());
        if (!matcher.matches()) {
            return CommandControl.NOT_OK;
        }
        if (list.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        matcher = MyPattern.cmpile(this.getPatternEnd()).matcher(list.get(list.size() - 1).trim());
        if (!matcher.matches()) {
            return CommandControl.OK_PARTIAL;
        }
        this.actionIfCommandValid();
        return CommandControl.OK;
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    protected final Pattern getStartingPattern() {
        return this.starting;
    }
}

