/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import java.util.regex.Matcher;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class CommandMultilinesHeader
extends CommandMultilines<UmlDiagram> {
    public CommandMultilinesHeader() {
        super("(?i)^(?:(left|right|center)?[%s]*)header$");
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?header$";
    }

    @Override
    public CommandExecutionResult execute(UmlDiagram umlDiagram, List<String> list) {
        Display display;
        StringUtils.trim(list, false);
        Matcher matcher = this.getStartingPattern().matcher(list.get(0).trim());
        if (!matcher.find()) {
            throw new IllegalStateException();
        }
        String string = matcher.group(1);
        if (string != null) {
            umlDiagram.setHeaderAlignment(HorizontalAlignment.valueOf(StringUtils.goUpperCase(string)));
        }
        if ((display = Display.create(list.subList(1, list.size() - 1))).size() > 0) {
            umlDiagram.setHeader(display);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Empty header");
    }
}

