/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Stereotype;

public class CommandNamespace
extends SingleLineCommand2<ClassDiagram> {
    public CommandNamespace() {
        super(CommandNamespace.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^namespace[%s]+"), new RegexLeaf("NAME", "([\\p{L}0-9_][\\p{L}0-9_.:]*)"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("[%s]*\\{$"));
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram classDiagram, RegexResult regexResult) {
        String string;
        Code code = Code.of(regexResult.get("NAME", 0));
        IGroup iGroup = classDiagram.getCurrentGroup();
        IGroup iGroup2 = classDiagram.getOrCreateNamespace(code, Display.getWithNewlines(code), GroupType.PACKAGE, iGroup);
        String string2 = regexResult.get("STEREOTYPE", 0);
        if (string2 != null) {
            iGroup2.setStereotype(new Stereotype(string2));
        }
        if ((string = regexResult.get("COLOR", 0)) != null) {
            iGroup2.setSpecificBackcolor(classDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(string));
        }
        return CommandExecutionResult.ok();
    }
}

