/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.List;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.version.Version;

public class ProtectedCommand<S extends Diagram>
implements Command<S> {
    private final Command<S> cmd;

    public ProtectedCommand(Command<S> command) {
        this.cmd = command;
    }

    @Override
    public CommandExecutionResult execute(S s, List<String> list) {
        try {
            CommandExecutionResult commandExecutionResult = this.cmd.execute(s, list);
            return commandExecutionResult;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            throwable.printStackTrace(printWriter);
            Log.error("Error " + throwable);
            String string = "You should send a mail to plantuml@gmail.com with this log (V" + Version.versionString() + ")";
            Log.error(string);
            string = string + " " + new String(byteArrayOutputStream.toByteArray());
            return CommandExecutionResult.error(string);
        }
    }

    @Override
    public CommandControl isValid(List<String> list) {
        return this.cmd.isValid(list);
    }

    @Override
    public String[] getDescription() {
        return this.cmd.getDescription();
    }
}

