/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.core.Diagram;

public abstract class SingleLineCommand<S extends Diagram>
implements Command<S> {
    private final Pattern pattern;

    public SingleLineCommand(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (!string.startsWith("(?i)^") || !string.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + string);
        }
        this.pattern = MyPattern.cmpile(string);
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.pattern.pattern()};
    }

    @Override
    public final CommandControl isValid(List<String> list) {
        if (list.size() != 1) {
            return CommandControl.NOT_OK;
        }
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        String string = list.get(0).trim();
        Matcher matcher = this.pattern.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            this.actionIfCommandValid();
        }
        return bl ? CommandControl.OK : CommandControl.NOT_OK;
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    @Override
    public final CommandExecutionResult execute(S s, List<String> list) {
        if (list.size() != 1) {
            throw new IllegalArgumentException();
        }
        String string = list.get(0).trim();
        if (this.isForbidden(string)) {
            return CommandExecutionResult.error("Forbidden line " + string);
        }
        List<String> list2 = this.getSplit(string);
        if (list2 == null) {
            return CommandExecutionResult.error("Cannot parse line " + string);
        }
        return this.executeArg(s, list2);
    }

    protected boolean isForbidden(String string) {
        return false;
    }

    protected abstract CommandExecutionResult executeArg(S var1, List<String> var2);

    public final List<String> getSplit(String string) {
        return StringUtils.getSplit(this.pattern, string);
    }
}

