/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.utils.UniqueSequence;

public final class FactoryNoteActivityCommand
implements SingleMultiFactoryCommand<ActivityDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("[%s]*"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public Command<ActivityDiagram> createMultiLine() {
        return new CommandMultilines2<ActivityDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^end[%s]?note$";
            }

            @Override
            public final CommandExecutionResult executeNow(ActivityDiagram activityDiagram, List<String> list) {
                Object object;
                RegexResult regexResult = this.getStartingPattern().matcher(list.get(0).trim());
                Display display = Display.create(StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1)));
                Url url = null;
                if (display.size() > 0) {
                    object = new UrlBuilder(activityDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                    url = ((UrlBuilder)object).getUrl(display.get(0).toString());
                }
                if (url != null) {
                    display = display.subList(1, display.size());
                }
                object = activityDiagram.createLeaf(UniqueSequence.getCode("GMN"), display, LeafType.NOTE, null);
                if (url != null) {
                    object.addUrl(url);
                }
                return FactoryNoteActivityCommand.this.executeInternal(activityDiagram, regexResult, (IEntity)object);
            }
        };
    }

    @Override
    public Command<ActivityDiagram> createSingleLine() {
        return new SingleLineCommand2<ActivityDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(ActivityDiagram activityDiagram, RegexResult regexResult) {
                IEntity iEntity = activityDiagram.createNote(UniqueSequence.getCode("GN"), Display.getWithNewlines(regexResult.get("NOTE", 0)));
                return FactoryNoteActivityCommand.this.executeInternal(activityDiagram, regexResult, iEntity);
            }
        };
    }

    private CommandExecutionResult executeInternal(ActivityDiagram activityDiagram, RegexResult regexResult, IEntity iEntity) {
        Link link;
        iEntity.setSpecificBackcolor(activityDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0)));
        IEntity iEntity2 = activityDiagram.getLastEntityConsulted();
        if (iEntity2 == null) {
            iEntity2 = activityDiagram.getStart();
        }
        Position position = Position.valueOf(StringUtils.goUpperCase(regexResult.get("POSITION", 0))).withRankdir(activityDiagram.getSkinParam().getRankdir());
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getDashed();
        if (position == Position.RIGHT) {
            link = new Link(iEntity2, iEntity, linkType, null, 1);
        } else if (position == Position.LEFT) {
            link = new Link(iEntity, iEntity2, linkType, null, 1);
        } else if (position == Position.BOTTOM) {
            link = new Link(iEntity2, iEntity, linkType, null, 2);
        } else if (position == Position.TOP) {
            link = new Link(iEntity, iEntity2, linkType, null, 2);
        } else {
            throw new IllegalArgumentException();
        }
        activityDiagram.addLink(link);
        return CommandExecutionResult.ok();
    }
}

