/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Link;

public final class FactoryNoteOnLinkCommand
implements SingleMultiFactoryCommand<CucaDiagram> {
    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)?[%s]*on[%s]+link"), new RegexLeaf("[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)?[%s]*on[%s]+link"), new RegexLeaf("[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("$"));
    }

    @Override
    public Command<CucaDiagram> createMultiLine() {
        return new CommandMultilines2<CucaDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^end[%s]?note$";
            }

            @Override
            public CommandExecutionResult executeNow(CucaDiagram cucaDiagram, List<String> list) {
                List<String> list2 = StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1));
                if (list2.size() > 0) {
                    RegexResult regexResult = this.getStartingPattern().matcher(list.get(0));
                    return FactoryNoteOnLinkCommand.this.executeInternal(cucaDiagram, list2, regexResult);
                }
                return CommandExecutionResult.error("No note defined");
            }
        };
    }

    @Override
    public Command<CucaDiagram> createSingleLine() {
        return new SingleLineCommand2<CucaDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(CucaDiagram cucaDiagram, RegexResult regexResult) {
                List<String> list = StringUtils.getWithNewlines2(regexResult.get("NOTE", 0));
                return FactoryNoteOnLinkCommand.this.executeInternal(cucaDiagram, list, regexResult);
            }
        };
    }

    private CommandExecutionResult executeInternal(CucaDiagram cucaDiagram, List<? extends CharSequence> list, RegexResult regexResult) {
        Link link = cucaDiagram.getLastLink();
        if (link == null) {
            return CommandExecutionResult.error("No link defined");
        }
        Position position = Position.BOTTOM;
        if (regexResult.get("POSITION", 0) != null) {
            position = Position.valueOf(StringUtils.goUpperCase(regexResult.get("POSITION", 0)));
        }
        Url url = null;
        if (list.size() > 0) {
            UrlBuilder urlBuilder = new UrlBuilder(cucaDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            url = urlBuilder.getUrl(list.get(0).toString());
        }
        if (url != null) {
            list = list.subList(1, list.size());
        }
        link.addNote(Display.create(list), position, cucaDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0)));
        return CommandExecutionResult.ok();
    }
}

