/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note.sequence;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.EventWithDeactivate;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public final class FactorySequenceNoteOnArrowCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^note[%s]+"), new RegexLeaf("POSITION", "(right|left)[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^note[%s]+"), new RegexLeaf("POSITION", "(right|left)[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult regexResult) {
                List<String> list = StringUtils.getWithNewlines2(regexResult.get("NOTE", 0));
                return FactorySequenceNoteOnArrowCommand.this.executeInternal(sequenceDiagram, regexResult, list);
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createMultiLine() {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^end[%s]?note$";
            }

            @Override
            public CommandExecutionResult executeNow(SequenceDiagram sequenceDiagram, List<String> list) {
                RegexResult regexResult = this.getStartingPattern().matcher(list.get(0).trim());
                List<String> list2 = StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1));
                return FactorySequenceNoteOnArrowCommand.this.executeInternal(sequenceDiagram, regexResult, list2);
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram sequenceDiagram, RegexResult regexResult, List<String> list) {
        EventWithDeactivate eventWithDeactivate = sequenceDiagram.getLastEventWithDeactivate();
        if (eventWithDeactivate instanceof AbstractMessage) {
            Url url;
            NotePosition notePosition = NotePosition.valueOf(StringUtils.goUpperCase(regexResult.get("POSITION", 0)));
            if (list.size() > 0) {
                UrlBuilder urlBuilder = new UrlBuilder(sequenceDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                url = urlBuilder.getUrl(list.get(0).toString());
            } else {
                url = null;
            }
            if (url != null) {
                list = list.subList(1, list.size());
            }
            ((AbstractMessage)eventWithDeactivate).setNote(Display.create(list), notePosition, regexResult.get("COLOR", 0), url);
        }
        return CommandExecutionResult.ok();
    }
}

