/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.openiconic.OpenIcon;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class AtomOpenIcon
implements Atom {
    private final OpenIcon openIcon;
    private final FontConfiguration fontConfiguration;
    private final double factor;

    public AtomOpenIcon(OpenIcon openIcon, FontConfiguration fontConfiguration) {
        this.openIcon = openIcon;
        this.fontConfiguration = fontConfiguration;
        this.factor = fontConfiguration.getSize2D() / 12.0;
    }

    private TextBlock asTextBlock() {
        return TextBlockUtils.withMargin(this.openIcon.asTextBlock(this.fontConfiguration.getColor(), this.factor), 1.0, 0.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.asTextBlock().calculateDimension(stringBounder);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return -3.0 * this.factor;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        this.asTextBlock().drawU(uGraphic);
    }
}

