/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.graphic.FontConfiguration;

public class CommandCreoleFontFamilyChange
implements Command {
    private final Pattern pattern;

    public static Command create() {
        return new CommandCreoleFontFamilyChange("^(?i)(\\<font[\\s:]+([^>]+)/?\\>(.*?)\\</font\\>)");
    }

    public static Command createEol() {
        return new CommandCreoleFontFamilyChange("^(?i)(\\<font[\\s:]+([^>]+)/?\\>(.*)$)");
    }

    private CommandCreoleFontFamilyChange(String string) {
        this.pattern = MyPattern.cmpile(string);
    }

    @Override
    public int matchingSize(String string) {
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.find()) {
            return 0;
        }
        return matcher.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fontConfiguration = stripeSimple.getActualFontConfiguration();
        String string2 = matcher.group(2);
        FontConfiguration fontConfiguration2 = fontConfiguration.changeFamily(string2);
        stripeSimple.setActualFontConfiguration(fontConfiguration2);
        stripeSimple.analyzeAndAdd(matcher.group(3));
        stripeSimple.setActualFontConfiguration(fontConfiguration);
        return string.substring(matcher.group(1).length());
    }
}

